/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*                  This file is part of the program and library             */
/*         SCIP --- Solving Constraint Integer Programs                      */
/*                                                                           */
/*  Copyright (c) 2002-2023 Zuse Institute Berlin (ZIB)                      */
/*                                                                           */
/*  Licensed under the Apache License, Version 2.0 (the "License");          */
/*  you may not use this file except in compliance with the License.         */
/*  You may obtain a copy of the License at                                  */
/*                                                                           */
/*      http://www.apache.org/licenses/LICENSE-2.0                           */
/*                                                                           */
/*  Unless required by applicable law or agreed to in writing, software      */
/*  distributed under the License is distributed on an "AS IS" BASIS,        */
/*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. */
/*  See the License for the specific language governing permissions and      */
/*  limitations under the License.                                           */
/*                                                                           */
/*  You should have received a copy of the Apache-2.0 license                */
/*  along with SCIP; see the file LICENSE. If not visit scipopt.org.         */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/**@file   objscip.h
 * @brief  C++ wrapper classes for SCIP
 * @author Tobias Achterberg
 */

/*---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2*/

#ifndef __SCIP_OBJSCIP_H__
#define __SCIP_OBJSCIP_H__


#include "objscip/objbenders.h"
#include "objscip/objbenderscut.h"
#include "objscip/objbranchrule.h"
#include "objscip/objconshdlr.h"
#include "objscip/objcutsel.h"
#include "objscip/objdialog.h"
#include "objscip/objdisp.h"
#include "objscip/objeventhdlr.h"
#include "objscip/objheur.h"
#include "objscip/objmessagehdlr.h"
#include "objscip/objnodesel.h"
#include "objscip/objpresol.h"
#include "objscip/objpricer.h"
#include "objscip/objprobdata.h"
#include "objscip/objprop.h"
#include "objscip/objreader.h"
#include "objscip/objrelax.h"
#include "objscip/objsepa.h"
#include "objscip/objvardata.h"
#include "objscip/objcloneable.h"

#endif
