<!--
title: Serverless Dashboard - Instrumentation
menuText: Instrumentation
layout: Doc
-->

<!-- DOCS-SITE-LINK:START automatically generated  -->

### [Read this on the main serverless docs site](https://www.serverless.com/framework/docs/guides/monitoring/instrumentation/)

<!-- DOCS-SITE-LINK:END -->

# Instrumentation

Once you have added the AWS Account Integration, you will need to enable
instrumentation on each AWS Lambda function to enable metric, log, trace, span,
and events collection in Serverless Framework Dashboard.

Currently Instrumentation is supported for the Node.js 12+ and Python 3.8+
runtimes only; however, other runtime support is coming soon.

## Enabling instrumentation for a function

To enable instrumentation go to **Settings** > **Integrations** and select the
AWS Integration, and click **Edit**.

On the integration settings page you'll have the option to set the
**Instrumentation** to **On**.

When instrumentation is enabled, then metrics, logs, traces, spans, and events
are collected and made available on Metrics and Explorer in Serverless Framework
Dashboard. Instrumentation is optimized for production use, as it adds virtually
no latency to the Lambda function, and Trace Sampling limits the number of
ingested traces.

## Trace Sampling

To help you reduce costs, Serverless Framework Dashboard provides Trace Sampling
to limit the number of ingested traces.

No further action is needed to enable sampling.

Trace sampling is applied progressively in proportion to invocation load. At
low volumes the sample rate will be 0%, meaning 100% of invocations will
generate traces, while at high volumes only 20% of successful invocations will
be generate traces.

If a trace contains any error or warning events, including any warnings
generated by the SDK (e.g. invalid tag key on `setTag()`), then the Trace will
not be sampled. This ensures that all errors and warnings will be available in
the Trace Explorer.

Metrics are not subject to Sampling. All metrics generated and collected by the
Instrumentation will continue to work, even if the trace was successful.

## Custom Instrumentation

In addition to the automatic instrumentation of your AWS Lambda functions, you
can also add custom instrumentation for setting tags, and events in your code.

Use the [Node.js](./nodejs-sdk.md) and [Python](./python-sdk.md) Serverless SDK
to add custom instrumentation.
