import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { DescribeTypeRegistrationInput, DescribeTypeRegistrationOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribeTypeRegistrationCommand}.
 */
export interface DescribeTypeRegistrationCommandInput extends DescribeTypeRegistrationInput {
}
/**
 * @public
 *
 * The output of {@link DescribeTypeRegistrationCommand}.
 */
export interface DescribeTypeRegistrationCommandOutput extends DescribeTypeRegistrationOutput, __MetadataBearer {
}
/**
 * @public
 * <p>Returns information about an extension's registration, including its current status and type and version
 *    identifiers.</p>
 *          <p>When you initiate a registration request using <a>RegisterType</a>, you can then use <a>DescribeTypeRegistration</a> to monitor the progress of that registration request.</p>
 *          <p>Once the registration request has completed, use <a>DescribeType</a> to return detailed information
 *    about an extension.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, DescribeTypeRegistrationCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, DescribeTypeRegistrationCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // DescribeTypeRegistrationInput
 *   RegistrationToken: "STRING_VALUE", // required
 * };
 * const command = new DescribeTypeRegistrationCommand(input);
 * const response = await client.send(command);
 * // { // DescribeTypeRegistrationOutput
 * //   ProgressStatus: "COMPLETE" || "IN_PROGRESS" || "FAILED",
 * //   Description: "STRING_VALUE",
 * //   TypeArn: "STRING_VALUE",
 * //   TypeVersionArn: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DescribeTypeRegistrationCommandInput - {@link DescribeTypeRegistrationCommandInput}
 * @returns {@link DescribeTypeRegistrationCommandOutput}
 * @see {@link DescribeTypeRegistrationCommandInput} for command's `input` shape.
 * @see {@link DescribeTypeRegistrationCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CFNRegistryException} (client fault)
 *  <p>An error occurred during a CloudFormation registry operation.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 */
export declare class DescribeTypeRegistrationCommand extends $Command<DescribeTypeRegistrationCommandInput, DescribeTypeRegistrationCommandOutput, CloudFormationClientResolvedConfig> {
    readonly input: DescribeTypeRegistrationCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: DescribeTypeRegistrationCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CloudFormationClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeTypeRegistrationCommandInput, DescribeTypeRegistrationCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
