import { HttpHandler, HttpRequest, HttpResponse } from "@smithy/protocol-http";
import { HttpHandlerOptions, Provider } from "@smithy/types";
/**
 * Represents the http options that can be passed to a browser http client.
 */
export interface FetchHttpHandlerOptions {
    /**
     * The number of milliseconds a request can take before being automatically
     * terminated.
     */
    requestTimeout?: number;
}
type FetchHttpHandlerConfig = FetchHttpHandlerOptions;
export declare class FetchHttpHandler implements HttpHandler<FetchHttpHandlerConfig> {
    private config?;
    private configProvider;
    constructor(options?: FetchHttpHandlerOptions | Provider<FetchHttpHandlerOptions | undefined>);
    destroy(): void;
    handle(request: HttpRequest, { abortSignal }?: HttpHandlerOptions): Promise<{
        response: HttpResponse;
    }>;
    updateHttpClientConfig(key: keyof FetchHttpHandlerConfig, value: FetchHttpHandlerConfig[typeof key]): void;
    httpHandlerConfigs(): FetchHttpHandlerConfig;
}
export {};
