/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.Method;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre21Compat;
import org.apache.tomcat.util.res.StringManager;

public class Jre22Compat
extends Jre21Compat {
    private static final Log log = LogFactory.getLog(Jre22Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre22Compat.class);
    private static final boolean hasPanama;

    static boolean isSupported() {
        return hasPanama;
    }

    static {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        Method method = null;
        try {
            clazz = Class.forName("java.lang.foreign.MemorySegment");
            clazz2 = Class.forName("java.io.Console");
            method = clazz.getMethod("getString", Long.TYPE);
            clazz2.getMethod("isTerminal", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug((Object)sm.getString("jre22Compat.javaPre22"), (Throwable)classNotFoundException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            log.debug((Object)sm.getString("jre22Compat.unexpected"), (Throwable)reflectiveOperationException);
        }
        hasPanama = method != null;
    }
}

