/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.grpc.NodeTemperatureSummaryMessage;
import org.opensearch.performanceanalyzer.grpc.ResourceTemperatureMessage;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.FullNodeTemperatureSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.NodeLevelDimensionalSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureVector;

public class CompactNodeSummary
extends GenericSummary {
    private static final Logger LOG = LogManager.getLogger(CompactNodeSummary.class);
    public static final String TABLE_NAME = CompactNodeSummary.class.getSimpleName();
    protected final String nodeId;
    protected final String hostAddress;
    protected TemperatureVector temperatureVector;
    protected double[] totalConsumedByDimension;
    protected int[] numOfShards;
    public static final String MEAN_SUFFIX_KEY = "_mean";
    public static final String TOTAL_SUFFIX_KEY = "_total";
    public static final String NUM_SHARDS_SUFFIX_KEY = "_num_shards";

    public CompactNodeSummary(String nodeId, String hostAddress) {
        this.nodeId = nodeId;
        this.hostAddress = hostAddress;
        this.temperatureVector = new TemperatureVector();
        this.totalConsumedByDimension = new double[TemperatureDimension.values().length];
        this.numOfShards = new int[TemperatureDimension.values().length];
    }

    public static CompactNodeSummary buildSummaryFromDatabase(Result<Record> records, DSLContext context) {
        if (records.size() != 1) {
            LOG.error("Expected 1 compact node summary, got {}. Summaries: {}", (Object)records.size(), records);
            throw new IllegalArgumentException("Only 1 CompactNodeSummary expected. Found: " + records.size());
        }
        Record record = (Record)records.get(0);
        String nodeId = (String)record.get(DSL.field((Name)DSL.name((String)"node_id"), String.class));
        String hostAddress = (String)record.get(DSL.field((Name)DSL.name((String)"host_address")), String.class);
        CompactNodeSummary summary = new CompactNodeSummary(nodeId, hostAddress);
        CompactNodeSummary.readAndSetTotalConsumedPerDimension(record, summary);
        CompactNodeSummary.readAndSetNumShardsPerDimension(record, summary);
        CompactNodeSummary.readAndSetTemperatureVector(record, summary);
        return summary;
    }

    private static void readAndSetTemperatureVector(Record record, CompactNodeSummary summary) {
        try {
            for (TemperatureDimension dimension : TemperatureDimension.values()) {
                String normalizedMeanUsageForDimension = (String)record.get(DSL.field((Name)DSL.name((String)(dimension.NAME + MEAN_SUFFIX_KEY)), String.class));
                short value = 0;
                if (normalizedMeanUsageForDimension != null && !normalizedMeanUsageForDimension.isEmpty()) {
                    value = Short.parseShort(normalizedMeanUsageForDimension);
                }
                summary.setTemperatureForDimension(dimension, new TemperatureVector.NormalizedValue(value));
            }
        }
        catch (DataTypeException dte) {
            LOG.error("Couldn't convert to the right data type while reading temperature vector from the DB. {}", (Object)dte.getMessage(), (Object)dte);
        }
    }

    private static void readAndSetNumShardsPerDimension(Record record, CompactNodeSummary summary) {
        try {
            for (TemperatureDimension dimension : TemperatureDimension.values()) {
                String numShardsForDimension = (String)record.get(DSL.field((Name)DSL.name((String)(dimension.NAME + NUM_SHARDS_SUFFIX_KEY)), String.class));
                int value = 0;
                if (numShardsForDimension != null && !numShardsForDimension.isEmpty()) {
                    value = Integer.parseInt(numShardsForDimension);
                }
                summary.setNumOfShards(dimension, value);
            }
        }
        catch (DataTypeException dte) {
            LOG.error("Couldn't convert to the right data type while reading num shards per dimension from the DB. {}", (Object)dte.getMessage(), (Object)dte);
        }
    }

    private static void readAndSetTotalConsumedPerDimension(Record record, CompactNodeSummary summary) {
        try {
            for (TemperatureDimension dimension : TemperatureDimension.values()) {
                String totalConsumedForDimension = (String)record.get(DSL.field((Name)DSL.name((String)(dimension.NAME + TOTAL_SUFFIX_KEY)), String.class));
                double value = 0.0;
                if (totalConsumedForDimension != null && !totalConsumedForDimension.isEmpty()) {
                    value = Double.parseDouble(totalConsumedForDimension);
                }
                summary.setTotalConsumedByDimension(dimension, value);
            }
        }
        catch (DataTypeException dte) {
            LOG.error("Couldn't convert to the right data type while reading total consumed per dimension from the DB. {}", (Object)dte.getMessage(), (Object)dte);
        }
    }

    public void fillFromNodeProfile(FullNodeTemperatureSummary nodeProfile) {
        this.temperatureVector = nodeProfile.getTemperatureVector();
        this.totalConsumedByDimension = new double[TemperatureDimension.values().length];
        this.numOfShards = new int[TemperatureDimension.values().length];
        for (NodeLevelDimensionalSummary nodeDimensionProfile : nodeProfile.getNodeDimensionProfiles()) {
            if (nodeDimensionProfile == null) continue;
            int index = nodeDimensionProfile.getProfileForDimension().ordinal();
            this.totalConsumedByDimension[index] = nodeDimensionProfile.getTotalUsage();
            this.numOfShards[index] = nodeDimensionProfile.getNumberOfShards();
        }
    }

    public double getTotalConsumedByDimension(TemperatureDimension dimension) {
        return this.totalConsumedByDimension[dimension.ordinal()];
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setTotalConsumedByDimension(TemperatureDimension dimension, double totalConsumedByDimension) {
        this.totalConsumedByDimension[dimension.ordinal()] = totalConsumedByDimension;
    }

    public void setNumOfShards(TemperatureDimension dimension, int numOfShards) {
        this.numOfShards[dimension.ordinal()] = numOfShards;
    }

    public int getNumberOfShardsByDimension(TemperatureDimension dimension) {
        return this.numOfShards[dimension.ordinal()];
    }

    public void setTemperatureForDimension(TemperatureDimension dimension, TemperatureVector.NormalizedValue value) {
        this.temperatureVector.updateTemperatureForDimension(dimension, value);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    @Nullable
    public TemperatureVector.NormalizedValue getTemperatureForDimension(TemperatureDimension dimension) {
        return this.temperatureVector.getTemperatureFor(dimension);
    }

    public NodeTemperatureSummaryMessage buildSummaryMessage() {
        if (this.totalConsumedByDimension == null) {
            throw new IllegalArgumentException("totalConsumedByDimension is not initialized");
        }
        NodeTemperatureSummaryMessage.Builder summaryBuilder = NodeTemperatureSummaryMessage.newBuilder();
        summaryBuilder.setNodeID(this.nodeId);
        summaryBuilder.setHostAddress(this.hostAddress);
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            int index = dimension.ordinal();
            ResourceTemperatureMessage.Builder builder = ResourceTemperatureMessage.newBuilder();
            builder.setResourceName(dimension.NAME);
            TemperatureVector.NormalizedValue normalizedMean = this.temperatureVector.getTemperatureFor(dimension);
            if (normalizedMean != null) {
                builder.setMeanUsage(normalizedMean.getPOINTS());
            } else {
                builder.setMeanUsage(0);
            }
            builder.setNumberOfShards(this.numOfShards[index]);
            builder.setTotalUsage(this.totalConsumedByDimension[index]);
            summaryBuilder.addCpuTemperature(index, builder);
        }
        return summaryBuilder.build();
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
        messageBuilder.setNodeTemperatureSummary(this.buildSummaryMessage());
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public static CompactNodeSummary buildNodeTemperatureProfileFromMessage(NodeTemperatureSummaryMessage message) {
        CompactNodeSummary compactNodeTemperatureSummary = new CompactNodeSummary(message.getNodeID(), message.getHostAddress());
        compactNodeTemperatureSummary.totalConsumedByDimension = new double[TemperatureDimension.values().length];
        compactNodeTemperatureSummary.numOfShards = new int[TemperatureDimension.values().length];
        for (ResourceTemperatureMessage resourceMessage : message.getCpuTemperatureList()) {
            TemperatureDimension dimension = TemperatureDimension.valueOf(resourceMessage.getResourceName());
            compactNodeTemperatureSummary.temperatureVector.updateTemperatureForDimension(dimension, new TemperatureVector.NormalizedValue((short)resourceMessage.getMeanUsage()));
            compactNodeTemperatureSummary.totalConsumedByDimension[dimension.ordinal()] = resourceMessage.getTotalUsage();
            compactNodeTemperatureSummary.numOfShards[dimension.ordinal()] = resourceMessage.getNumberOfShards();
        }
        return compactNodeTemperatureSummary;
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        ArrayList schema = new ArrayList();
        schema.add(DSL.field((Name)DSL.name((String)"node_id"), String.class));
        schema.add(DSL.field((Name)DSL.name((String)"host_address"), String.class));
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            schema.add(DSL.field((Name)DSL.name((String)(dimension.NAME + MEAN_SUFFIX_KEY)), String.class));
            schema.add(DSL.field((Name)DSL.name((String)(dimension.NAME + TOTAL_SUFFIX_KEY)), String.class));
            schema.add(DSL.field((Name)DSL.name((String)(dimension.NAME + NUM_SHARDS_SUFFIX_KEY)), String.class));
        }
        return schema;
    }

    @Override
    public List<Object> getSqlValue() {
        ArrayList<Object> value = new ArrayList<Object>();
        value.add(this.nodeId);
        value.add(this.hostAddress);
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            value.add(this.temperatureVector.getTemperatureFor(dimension));
            value.add(this.totalConsumedByDimension[dimension.ordinal()]);
            value.add(this.numOfShards[dimension.ordinal()]);
        }
        return value;
    }

    @Override
    public JsonElement toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("node_id", this.nodeId);
        jsonObject.addProperty("host_address", this.hostAddress);
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            TemperatureVector.NormalizedValue ret = this.temperatureVector.getTemperatureFor(dimension);
            if (ret == null) {
                ret = new TemperatureVector.NormalizedValue(0);
            }
            jsonObject.addProperty(dimension.NAME + MEAN_SUFFIX_KEY, (Number)ret.getPOINTS());
            jsonObject.addProperty(dimension.NAME + TOTAL_SUFFIX_KEY, (Number)this.totalConsumedByDimension[dimension.ordinal()]);
            jsonObject.addProperty(dimension.NAME + NUM_SHARDS_SUFFIX_KEY, (Number)this.numOfShards[dimension.ordinal()]);
        }
        return jsonObject;
    }
}

