/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SelectJoinStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.DBUtils;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.MetricPropertiesConfig;
import org.opensearch.performanceanalyzer.reader.Removable;

public class MemoryDBSnapshot
implements Removable {
    private static final Logger LOG = LogManager.getLogger(MemoryDBSnapshot.class);
    private static final String WEIGHT = "weight";
    private static final Field<Double> WEIGHT_FIELD = DSL.field((String)"weight", Double.class);
    protected final DSLContext create;
    protected final String tableName;
    protected long lastUpdatedTime;
    private final List<String> dimensionNames;
    private final List<Field<String>> dimensionsFields;
    private final List<Field<Double>> metadata;
    private final Map<String, List<Field<?>>> tableSelectFieldsMap;
    private final Map<String, List<Field<String>>> tableGroupByFieldsMap;
    private final Map<String, Condition> tableWhereClauseMap;
    private final boolean isAligned;

    public MemoryDBSnapshot(Connection conn, AllMetrics.MetricName tableNamePrefix, long windowEndTime, boolean aligned) {
        this.create = DSL.using((Connection)conn, (SQLDialect)SQLDialect.SQLITE);
        this.isAligned = aligned;
        String tableNameSuffix = aligned ? "_aligned" : "";
        this.tableName = tableNamePrefix.toString() + windowEndTime + tableNameSuffix;
        this.lastUpdatedTime = -1L;
        this.dimensionNames = MetricPropertiesConfig.getInstance().getProperty(tableNamePrefix).getDimensionNames();
        this.dimensionsFields = MetricPropertiesConfig.getInstance().getProperty(tableNamePrefix).getDimensionFields();
        this.metadata = MetricPropertiesConfig.getInstance().getProperty(tableNamePrefix).getMetricFields();
        this.tableSelectFieldsMap = MetricPropertiesConfig.getInstance().getProperty(tableNamePrefix).getTableSelectMap();
        this.tableGroupByFieldsMap = MetricPropertiesConfig.getInstance().getProperty(tableNamePrefix).getTableGroupByFieldsMap();
        this.tableWhereClauseMap = MetricPropertiesConfig.getInstance().getProperty(tableNamePrefix).getTableWhereClauseMap();
        LOG.debug("Creating a new snapshot table - {}", (Object)this.tableName);
        this.create.createTable(this.tableName).columns(this.dimensionsFields).columns(this.metadata).execute();
    }

    public MemoryDBSnapshot(Connection conn, AllMetrics.MetricName tableNamePrefix, long windowEndTime) {
        this(conn, tableNamePrefix, windowEndTime, false);
    }

    public DSLContext getDSLContext() {
        return this.create;
    }

    @Override
    public void remove() {
        LOG.debug("Dropping {}", (Object)this.tableName);
        if (this.dbTableExists()) {
            this.create.dropTable(DSL.table((String)this.tableName)).execute();
        }
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(long lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public String getTableName() {
        return this.tableName;
    }

    public SelectHavingStep<Record> selectAll() {
        return this.create.select(new SelectField[0]).from(this.tableName);
    }

    public Result<Record> fetchAll() {
        return this.create.select(new SelectField[0]).from((TableLike)DSL.table((String)this.tableName)).fetch();
    }

    public BatchBindStep startBatchPut() {
        int i;
        int totalSize = this.dimensionsFields.size() + this.metadata.size();
        ArrayList<Object> dummyValues = new ArrayList<Object>(totalSize);
        for (i = 0; i < this.dimensionsFields.size(); ++i) {
            dummyValues.add(null);
        }
        for (i = 0; i < this.metadata.size(); ++i) {
            dummyValues.add(null);
        }
        return this.create.batch((Query)this.create.insertInto(DSL.table((String)this.tableName)).values(dummyValues));
    }

    public List<Field<String>> getDimensions() {
        return this.dimensionsFields;
    }

    public Collection<Field<Double>> getMetrics() {
        return this.metadata;
    }

    public void alignWindow(MemoryDBSnapshot leftWindow, MemoryDBSnapshot rightWindow, long t, long a, long b) {
        ArrayList<Object> alignedFields = new ArrayList<Object>();
        alignedFields.addAll(this.getDimensions());
        for (Field<Double> field : this.getMetrics()) {
            alignedFields.add(DSL.sum(field).div((Field)DSL.sum(WEIGHT_FIELD)).as(field));
        }
        ArrayList<Object> leftWinFields = new ArrayList<Object>();
        leftWinFields.addAll(this.getDimensions());
        leftWinFields.add(DSL.val((long)(t - a)).as(WEIGHT));
        for (Field<Double> field : this.getMetrics()) {
            leftWinFields.add(field.mul((Number)(t - a)).as(field.getName()));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(this.getDimensions());
        arrayList.add(DSL.val((long)(b - t)).as(WEIGHT));
        for (Field<Double> field : this.getMetrics()) {
            arrayList.add(field.mul((Number)(b - t)).as(field.getName()));
        }
        SelectJoinStep selectJoinStep = this.create.select(alignedFields).from((TableLike)this.create.select(leftWinFields).from(leftWindow.tableName).unionAll((Select)this.create.select(arrayList).from(rightWindow.getTableName())));
        if (this.getDimensions().isEmpty()) {
            this.create.insertInto(DSL.table((String)this.tableName)).select((Select)selectJoinStep).execute();
        } else {
            this.create.insertInto(DSL.table((String)this.tableName)).select((Select)selectJoinStep.groupBy(this.getDimensions())).execute();
        }
    }

    public void insertMultiRows(Object[][] values) {
        if (values == null || values.length == 0) {
            return;
        }
        BatchBindStep batchHandle = this.startBatchPut();
        for (int i = 0; i < values.length; ++i) {
            batchHandle.bind(values[i]);
        }
        batchHandle.execute();
    }

    protected Result<Record> fetchMetric(Condition condition, SelectField<?> ... column) {
        return this.create.select(column).from((TableLike)DSL.table((String)this.tableName)).where(new Condition[]{condition}).fetch();
    }

    protected boolean dbTableExists() {
        return DBUtils.checkIfTableExists(this.create, this.tableName);
    }

    protected Result<Record1<String>> fetchTableSchema() {
        return this.create.select((SelectField)DSL.field((String)"sql", String.class)).from((TableLike)DSL.table((String)"sqlite_cluster_manager")).where(new Condition[]{DSL.field((String)"name", String.class).eq((Object)this.tableName)}).fetch();
    }

    public Map<String, SelectHavingStep<Record>> selectMetadataSource() {
        HashMap<String, SelectHavingStep<Record>> selectFromTable = new HashMap<String, SelectHavingStep<Record>>();
        for (Map.Entry<String, List<Field<?>>> entry : this.tableSelectFieldsMap.entrySet()) {
            String tableName = entry.getKey();
            selectFromTable.put(tableName, (SelectHavingStep<Record>)this.create.select((Collection)entry.getValue()).from(this.tableName).where(new Condition[]{this.tableWhereClauseMap.get(tableName)}).groupBy((Collection)this.tableGroupByFieldsMap.get(tableName)));
        }
        return selectFromTable;
    }

    public Map<String, List<Field<?>>> getTableSelectFieldsMap() {
        return this.tableSelectFieldsMap;
    }

    public List<String> getDimensionNames() {
        return this.dimensionNames;
    }

    public boolean isAligned() {
        return this.isAligned;
    }
}

