/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.DBUtils;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.HttpRequestMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.Removable;

public class ShardRequestMetricsSnapshot
implements Removable {
    private static final Logger LOG = LogManager.getLogger(ShardRequestMetricsSnapshot.class);
    private static final ArrayList<Field<?>> groupByRidOp = new ArrayList<Field<?>>(){
        {
            this.add(DSL.field((Name)DSL.name((String)Fields.RID.name()), String.class));
            this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.name()), String.class));
        }
    };
    private final DSLContext create;
    public final Long windowStartTime;
    private final String tableName;
    private static final Long EXPIRE_AFTER = 600000L;
    private List<Field<?>> columns;

    public ShardRequestMetricsSnapshot(Connection conn, Long windowStartTime) throws Exception {
        this.create = DSL.using((Connection)conn, (SQLDialect)SQLDialect.SQLITE);
        this.windowStartTime = windowStartTime;
        this.tableName = "shard_rq_" + windowStartTime;
        this.columns = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.TID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ROLE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.DOC_COUNT.toString()), Long.class));
            }
        };
        this.create.createTable(this.tableName).columns(this.columns).execute();
    }

    public void putStartMetric(Long startTime, Map<String, String> dimensions) {
        HashMap<Field, String> dimensionMap = new HashMap<Field, String>();
        for (Map.Entry<String, String> dimension : dimensions.entrySet()) {
            dimensionMap.put(DSL.field((Name)DSL.name((String)dimension.getKey()), String.class), dimension.getValue());
        }
        this.create.insertInto(DSL.table((String)this.tableName)).set(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class), (Object)startTime).set(dimensionMap).execute();
    }

    public BatchBindStep startBatchPut() {
        ArrayList<Object> dummyValues = new ArrayList<Object>();
        for (int i = 0; i < this.columns.size(); ++i) {
            dummyValues.add(null);
        }
        return this.create.batch((Query)this.create.insertInto(DSL.table((String)this.tableName)).values(dummyValues));
    }

    public void putEndMetric(Long endTime, Map<String, String> dimensions) {
        HashMap<Field, String> dimensionMap = new HashMap<Field, String>();
        for (Map.Entry<String, String> dimension : dimensions.entrySet()) {
            dimensionMap.put(DSL.field((Name)DSL.name((String)dimension.getKey()), String.class), dimension.getValue());
        }
        this.create.insertInto(DSL.table((String)this.tableName)).set(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class), (Object)endTime).set(dimensionMap).execute();
    }

    public Result<Record> fetchAll() {
        return this.create.select(new SelectField[0]).from((TableLike)DSL.table((String)this.tableName)).fetch();
    }

    public SelectHavingStep<Record> fetchLatency() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.TID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ROLE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.DOC_COUNT.toString()), Double.class));
                this.add(DSL.field((String)Fields.ET.toString()).minus(DSL.field((String)Fields.ST.toString())).as(DSL.name((String)Fields.LAT.toString())));
            }
        };
        return this.create.select((Collection)fields).from(this.groupByRidOpSelect()).where(new Condition[]{DSL.field((String)Fields.ET.toString()).isNotNull().and(DSL.field((String)Fields.ST.toString()).isNotNull())});
    }

    public Result<Record> fetchLatencyByOp() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ROLE.toString()), String.class));
                this.add(DSL.sum((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "sum")));
                this.add(DSL.avg((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "avg")));
                this.add(DSL.min((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "min")));
                this.add(DSL.max((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "max")));
                this.add(DSL.count().as(AllMetrics.ShardOperationMetric.SHARD_OP_COUNT.toString()));
                this.add(DSL.sum((Field)DSL.field((Name)DSL.name((String)Fields.DOC_COUNT.toString()), Double.class)).as(AllMetrics.ShardBulkMetric.DOC_COUNT.toString()));
            }
        };
        ArrayList groupByFields = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ROLE.toString()), String.class));
            }
        };
        return this.create.select((Collection)fields).from(this.fetchLatency()).groupBy((Collection)groupByFields).fetch();
    }

    public SelectHavingStep<Record> getCoalescedRequestsForTimeSpentInWindow() {
        Long endTime = this.windowStartTime + 5000L;
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.TID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ROLE.toString()), String.class));
            }
        };
        fields.add((SelectField<?>)DSL.greatest((Object)DSL.coalesce((Field)DSL.max((Field)DSL.field((String)Fields.ST.toString())), (Object)this.windowStartTime), (Object[])new Serializable[]{this.windowStartTime}).as(DSL.name((String)Fields.ST.toString())));
        fields.add((SelectField<?>)DSL.least((Object)DSL.coalesce((Field)DSL.max((Field)DSL.field((String)Fields.ET.toString())), (Object)endTime), (Object[])new Serializable[]{endTime}).as(DSL.name((String)Fields.ET.toString())));
        return this.create.select((Collection)fields).from((TableLike)DSL.table((String)this.tableName)).groupBy(groupByRidOp);
    }

    public SelectHavingStep<Record> getTimeSpentPerRequest() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.TID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ROLE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class));
            }
        };
        fields.add((SelectField<?>)DSL.field((String)Fields.ET.toString()).minus(DSL.field((String)Fields.ST.toString())).as(DSL.name((String)Fields.LAT.toString())));
        return this.create.select((Collection)fields).from(this.getCoalescedRequestsForTimeSpentInWindow());
    }

    public SelectHavingStep<Record> groupByRidOpSelect() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.TID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ROLE.toString()), String.class));
                this.add(DSL.max((Field)DSL.field((String)Fields.DOC_COUNT.toString())).as(DSL.name((String)Fields.DOC_COUNT.toString())));
                this.add(DSL.max((Field)DSL.field((String)Fields.ST.toString())).as(DSL.name((String)Fields.ST.toString())));
                this.add(DSL.max((Field)DSL.field((String)Fields.ET.toString())).as(DSL.name((String)Fields.ET.toString())));
            }
        };
        return this.create.select((Collection)fields).from((TableLike)DSL.table((String)this.tableName)).groupBy(groupByRidOp);
    }

    public SelectHavingStep<Record> requestsPerThreadSelect() {
        final SelectHavingStep<Record> groupByRidOp = this.groupByRidOpSelect();
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((SelectField)groupByRidOp.field(Fields.TID.toString())));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ROLE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.DOC_COUNT.toString()), Double.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.LATEST.toString()), Long.class));
            }
        };
        SelectHavingStep threadTable = this.create.select((SelectField)DSL.max((Field)DSL.field((String)Fields.ST.toString(), Long.class)).as(Fields.LATEST.toString()), (SelectField)DSL.field((Name)DSL.name((String)Fields.TID.toString()), String.class).as(Fields.TID.toString())).from(groupByRidOp).groupBy(new GroupField[]{DSL.field((String)Fields.TID.toString())});
        return this.create.select((Collection)fields).from(groupByRidOp).join((TableLike)threadTable).on(new Condition[]{threadTable.field(DSL.field((String)Fields.TID.toString())).eq((Object)groupByRidOp.field(Fields.TID.toString()))});
    }

    public SelectHavingStep<Record> fetchInflightSelect() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.INDEX_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.TID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.OPERATION.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.SHARD_ROLE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.DOC_COUNT.toString()), Long.class));
            }
        };
        SelectHavingStep<Record> reqPerThread = this.requestsPerThreadSelect();
        return this.create.select((Collection)fields).from(reqPerThread).where(new Condition[]{DSL.field((String)Fields.ST.toString()).isNotNull().and(DSL.field((String)Fields.ST.toString()).gt((Object)this.windowStartTime).or(DSL.field((String)Fields.LATEST.toString()).eq(DSL.field((String)Fields.ST.toString())))).and(DSL.field((String)Fields.ET.toString()).isNull()).and(DSL.field((String)Fields.ST.toString()).gt((Object)(this.windowStartTime - EXPIRE_AFTER)))});
    }

    public SelectHavingStep<Record> fetchTotalTimeTable(SelectHavingStep<Record> timeSpentPerRequestSelect) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(DSL.field((String)Fields.TID.toString()));
        fields.add(DSL.sum((Field)DSL.field((String)Fields.LAT.toString(), Double.class)).as(Fields.TTIME.toString()));
        return this.create.select(fields).from(timeSpentPerRequestSelect).groupBy(new GroupField[]{DSL.field((String)Fields.TID.toString())});
    }

    public Result<Record> fetchThreadUtilizationRatio() {
        return this.create.select(new SelectField[0]).from(this.fetchThreadUtilizationRatioTable()).fetch();
    }

    public SelectHavingStep<Record> fetchThreadUtilizationRatioTable() {
        ArrayList<Field> requestAndTotalThreadTimeFields = new ArrayList<Field>();
        SelectHavingStep<Record> timeSpentPerReq = this.getTimeSpentPerRequest();
        SelectHavingStep<Record> threadTable = this.fetchTotalTimeTable(timeSpentPerReq);
        requestAndTotalThreadTimeFields.addAll(Arrays.asList(timeSpentPerReq.fields()));
        requestAndTotalThreadTimeFields.add(threadTable.field(Fields.TTIME.toString()));
        SelectOnConditionStep requestAndTotalThreadTimeSelect = this.create.select(requestAndTotalThreadTimeFields).from(timeSpentPerReq).join(threadTable).on(new Condition[]{timeSpentPerReq.field(Fields.TID.toString(), String.class).eq(threadTable.field(Fields.TID.toString(), String.class))});
        ArrayList<Field> tUtilFields = new ArrayList<Field>();
        tUtilFields.addAll(Arrays.asList(requestAndTotalThreadTimeSelect.fields()));
        tUtilFields.add(requestAndTotalThreadTimeSelect.field(Fields.LAT.toString()).mul((Field)DSL.val((double)1.0)).div(requestAndTotalThreadTimeSelect.field(Fields.TTIME.toString(), Double.class)).as(Fields.TUTIL.toString()));
        return this.create.select(tUtilFields).from((TableLike)requestAndTotalThreadTimeSelect);
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void remove() {
        this.create.dropTable(DSL.table((String)this.tableName)).execute();
    }

    public void rolloverInflightRequests(ShardRequestMetricsSnapshot prevSnap) {
        this.create.insertInto(DSL.table((String)this.tableName)).select(prevSnap.fetchInflightSelect()).execute();
        LOG.debug("Inflight shard requests");
        LOG.debug(() -> this.fetchAll());
    }

    public static enum Fields {
        SHARD_ID(AllMetrics.CommonDimension.SHARD_ID.toString()),
        INDEX_NAME(AllMetrics.CommonDimension.INDEX_NAME.toString()),
        RID(HttpRequestMetricsSnapshot.Fields.RID.toString()),
        TID("tid"),
        OPERATION(AllMetrics.CommonDimension.OPERATION.toString()),
        SHARD_ROLE(AllMetrics.CommonDimension.SHARD_ROLE.toString()),
        ST(HttpRequestMetricsSnapshot.Fields.ST.toString()),
        ET(HttpRequestMetricsSnapshot.Fields.ET.toString()),
        LAT(HttpRequestMetricsSnapshot.Fields.LAT.toString()),
        TUTIL("tUtil"),
        TTIME("ttime"),
        LATEST("latest"),
        DOC_COUNT(AllMetrics.ShardBulkMetric.DOC_COUNT.toString());

        private final String fieldValue;

        private Fields(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        public String toString() {
            return this.fieldValue;
        }
    }
}

