/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.extended;

import java.util.ArrayList;
import java.util.Arrays;
import org.ldaptive.AbstractRequest;
import org.ldaptive.Credential;
import org.ldaptive.asn1.ConstructedDEREncoder;
import org.ldaptive.asn1.ContextType;
import org.ldaptive.asn1.DEREncoder;
import org.ldaptive.asn1.UniversalDERTag;
import org.ldaptive.extended.ExtendedRequest;

public class PasswordModifyRequest
extends AbstractRequest
implements ExtendedRequest {
    public static final String OID = "1.3.6.1.4.1.4203.1.11.1";
    private String userIdentity;
    private Credential oldPassword;
    private Credential newPassword;

    public PasswordModifyRequest() {
    }

    public PasswordModifyRequest(String identity) {
        this.setUserIdentity(identity);
    }

    public PasswordModifyRequest(String identity, Credential oldPass, Credential newPass) {
        this.setUserIdentity(identity);
        this.setOldPassword(oldPass);
        this.setNewPassword(newPass);
    }

    public String getUserIdentity() {
        return this.userIdentity;
    }

    public void setUserIdentity(String identity) {
        this.userIdentity = identity;
    }

    public Credential getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(Credential oldPass) {
        this.oldPassword = oldPass;
    }

    public Credential getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(Credential newPass) {
        this.newPassword = newPass;
    }

    @Override
    public byte[] encode() {
        ArrayList<ContextType> l = new ArrayList<ContextType>();
        if (this.getUserIdentity() != null) {
            l.add(new ContextType(0, this.getUserIdentity()));
        }
        if (this.getOldPassword() != null) {
            l.add(new ContextType(1, this.getOldPassword().getString()));
        }
        if (this.getNewPassword() != null) {
            l.add(new ContextType(2, this.getNewPassword().getString()));
        }
        ConstructedDEREncoder se = new ConstructedDEREncoder(UniversalDERTag.SEQ, l.toArray(new DEREncoder[l.size()]));
        return se.encode();
    }

    @Override
    public String getOID() {
        return OID;
    }

    public String toString() {
        return String.format("[%s@%d::userIdentity=%s, controls=%s, referralHandler=%s, intermediateResponseHandlers=%s]", this.getClass().getName(), this.hashCode(), this.userIdentity, Arrays.toString(this.getControls()), this.getReferralHandler(), Arrays.toString(this.getIntermediateResponseHandlers()));
    }
}

