/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf.impl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.ExceptionsHelper;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.NonValidatingObjectMapper;
import org.opensearch.security.securityconf.Hashed;
import org.opensearch.security.securityconf.Hideable;
import org.opensearch.security.securityconf.StaticDefinable;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.Meta;

public class SecurityDynamicConfiguration<T>
implements ToXContent {
    private static final TypeReference<HashMap<String, Object>> typeRefMSO = new TypeReference<HashMap<String, Object>>(){};
    @JsonIgnore
    private final Map<String, T> centries = new HashMap<String, T>();
    private long seqNo = -1L;
    private long primaryTerm = -1L;
    private CType ctype;
    private int version = -1;
    private Meta _meta;

    public static <T> SecurityDynamicConfiguration<T> empty() {
        return new SecurityDynamicConfiguration<T>();
    }

    public static <T> SecurityDynamicConfiguration<T> fromJson(String json, CType ctype, int version, long seqNo, long primaryTerm) throws IOException {
        return SecurityDynamicConfiguration.fromJson(json, ctype, version, seqNo, primaryTerm, false);
    }

    public static <T> SecurityDynamicConfiguration<T> fromJson(String json, CType ctype, int version, long seqNo, long primaryTerm, boolean acceptInvalid) throws IOException {
        SecurityDynamicConfiguration sdc = null;
        if (ctype != null) {
            Class<?> implementationClass = ctype.getImplementationClass().get(version);
            if (implementationClass == null) {
                throw new IllegalArgumentException("No implementation class found for " + ctype + " and config version " + version);
            }
            sdc = acceptInvalid && version < 2 ? (SecurityDynamicConfiguration)NonValidatingObjectMapper.readValue(json, NonValidatingObjectMapper.getTypeFactory().constructParametricType(SecurityDynamicConfiguration.class, new Class[]{implementationClass})) : (SecurityDynamicConfiguration)DefaultObjectMapper.readValue(json, DefaultObjectMapper.getTypeFactory().constructParametricType(SecurityDynamicConfiguration.class, new Class[]{implementationClass}));
            SecurityDynamicConfiguration.validate(sdc, version, ctype);
        } else {
            sdc = new SecurityDynamicConfiguration();
        }
        sdc.ctype = ctype;
        sdc.seqNo = seqNo;
        sdc.primaryTerm = primaryTerm;
        sdc.version = version;
        return sdc;
    }

    public static void validate(SecurityDynamicConfiguration sdc, int version, CType ctype) throws IOException {
        if (version < 2 && sdc.get_meta() != null) {
            throw new IOException("A version of " + version + " can not have a _meta key for " + ctype);
        }
        if (version >= 2 && sdc.get_meta() == null) {
            throw new IOException("A version of " + version + " must have a _meta key for " + ctype);
        }
        if (!(version >= 2 || ctype != CType.CONFIG || sdc.getCEntries().size() == 1 && sdc.getCEntries().keySet().contains("opendistro_security"))) {
            throw new IOException("A version of " + version + " must have a single toplevel key named 'opendistro_security' for " + ctype);
        }
        if (!(version < 2 || ctype != CType.CONFIG || sdc.getCEntries().size() == 1 && sdc.getCEntries().keySet().contains("config"))) {
            throw new IOException("A version of " + version + " must have a single toplevel key named 'config' for " + ctype);
        }
    }

    public static <T> SecurityDynamicConfiguration<T> fromNode(JsonNode json, CType ctype, int version, long seqNo, long primaryTerm) throws IOException {
        return SecurityDynamicConfiguration.fromJson(DefaultObjectMapper.writeValueAsString(json, false), ctype, version, seqNo, primaryTerm);
    }

    private SecurityDynamicConfiguration() {
    }

    public Meta get_meta() {
        return this._meta;
    }

    public void set_meta(Meta _meta) {
        this._meta = _meta;
    }

    @JsonAnySetter
    void setCEntries(String key, T value) {
        this.putCEntry(key, value);
    }

    @JsonAnyGetter
    public Map<String, T> getCEntries() {
        return this.centries;
    }

    @JsonIgnore
    public void removeHidden() {
        for (Map.Entry<String, T> entry : new HashMap<String, T>(this.centries).entrySet()) {
            if (!(entry.getValue() instanceof Hideable) || !((Hideable)entry.getValue()).isHidden()) continue;
            this.centries.remove(entry.getKey());
        }
    }

    @JsonIgnore
    public void removeStatic() {
        for (Map.Entry<String, T> entry : new HashMap<String, T>(this.centries).entrySet()) {
            if (!(entry.getValue() instanceof StaticDefinable) || !((StaticDefinable)entry.getValue()).isStatic()) continue;
            this.centries.remove(entry.getKey());
        }
    }

    @JsonIgnore
    public void clearHashes() {
        for (Map.Entry<String, T> entry : this.centries.entrySet()) {
            if (!(entry.getValue() instanceof Hashed)) continue;
            ((Hashed)entry.getValue()).clearHash();
        }
    }

    public void removeOthers(String key) {
        T tmp = this.centries.get(key);
        this.centries.clear();
        this.centries.put(key, tmp);
    }

    @JsonIgnore
    public T putCEntry(String key, T value) {
        return this.centries.put(key, value);
    }

    @JsonIgnore
    public void putCObject(String key, Object value) {
        this.centries.put(key, value);
    }

    @JsonIgnore
    public T getCEntry(String key) {
        return this.centries.get(key);
    }

    @JsonIgnore
    public boolean exists(String key) {
        return this.centries.containsKey(key);
    }

    public String toString() {
        return "SecurityDynamicConfiguration [seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", ctype=" + this.ctype + ", version=" + this.version + ", centries=" + this.centries + ", getImplementingClass()=" + this.getImplementingClass() + "]";
    }

    @JsonIgnore
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean omitDefaults = params != null && params.paramAsBoolean("omit_defaults", false);
        return builder.map((Map)DefaultObjectMapper.readValue(DefaultObjectMapper.writeValueAsString(this, omitDefaults), typeRefMSO));
    }

    @JsonIgnore
    public boolean isFragment() {
        return false;
    }

    @JsonIgnore
    public long getSeqNo() {
        return this.seqNo;
    }

    @JsonIgnore
    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @JsonIgnore
    public CType getCType() {
        return this.ctype;
    }

    @JsonIgnore
    public void setCType(CType ctype) {
        this.ctype = ctype;
    }

    @JsonIgnore
    public int getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Class<?> getImplementingClass() {
        return this.ctype == null ? null : this.ctype.getImplementationClass().get(this.getVersion());
    }

    @JsonIgnore
    public SecurityDynamicConfiguration<T> deepClone() {
        try {
            return SecurityDynamicConfiguration.fromJson(DefaultObjectMapper.writeValueAsString(this, false), this.ctype, this.version, this.seqNo, this.primaryTerm);
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    @JsonIgnore
    public void remove(String key) {
        this.centries.remove(key);
    }

    public boolean add(SecurityDynamicConfiguration other) {
        if (other.ctype == null || !other.ctype.equals((Object)this.ctype)) {
            return false;
        }
        if (other.getImplementingClass() == null || !other.getImplementingClass().equals(this.getImplementingClass())) {
            return false;
        }
        if (other.version != this.version) {
            return false;
        }
        this.centries.putAll(other.centries);
        return true;
    }

    @JsonIgnore
    public boolean containsAny(SecurityDynamicConfiguration other) {
        return !Collections.disjoint(this.centries.keySet(), other.centries.keySet());
    }

    public boolean isHidden(String resourceName) {
        T o = this.centries.get(resourceName);
        return o instanceof Hideable && ((Hideable)o).isHidden();
    }

    @JsonIgnore
    public boolean isStatic(String resourceName) {
        T o = this.centries.get(resourceName);
        return o instanceof StaticDefinable && ((StaticDefinable)o).isStatic();
    }

    @JsonIgnore
    public boolean isReserved(String resourceName) {
        T o = this.centries.get(resourceName);
        return o instanceof Hideable && ((Hideable)o).isReserved();
    }
}

