/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.opensearch.geo.search.aggregations.metrics.GeoBoundsAggregationBuilder;
import org.opensearch.geo.search.aggregations.metrics.GeoBoundsAggregator;
import org.opensearch.geo.search.aggregations.metrics.GeoBoundsGeoShapeAggregator;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.metrics.GeoBoundsAggregatorSupplier;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.internal.SearchContext;

class GeoBoundsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final boolean wrapLongitude;

    GeoBoundsAggregatorFactory(String name, ValuesSourceConfig config, boolean wrapLongitude, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.wrapLongitude = wrapLongitude;
    }

    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new GeoBoundsAggregator(this.name, searchContext, parent, this.config, this.wrapLongitude, metadata);
    }

    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return ((GeoBoundsAggregatorSupplier)this.queryShardContext.getValuesSourceRegistry().getAggregator(GeoBoundsAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, searchContext, parent, this.config, this.wrapLongitude, metadata);
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(GeoBoundsAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.GEOPOINT, GeoBoundsAggregator::new, true);
        builder.register(GeoBoundsAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.GEO_SHAPE, GeoBoundsGeoShapeAggregator::new, true);
    }
}

