/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.transport;

import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasources.model.transport.UpdateDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.UpdateDataSourceActionResponse;
import org.opensearch.sql.datasources.service.DataSourceServiceImpl;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportUpdateDataSourceAction
extends HandledTransportAction<UpdateDataSourceActionRequest, UpdateDataSourceActionResponse> {
    public static final String NAME = "cluster:admin/opensearch/ql/datasources/update";
    public static final ActionType<UpdateDataSourceActionResponse> ACTION_TYPE = new ActionType("cluster:admin/opensearch/ql/datasources/update", UpdateDataSourceActionResponse::new);
    private DataSourceService dataSourceService;

    @Inject
    public TransportUpdateDataSourceAction(TransportService transportService, ActionFilters actionFilters, DataSourceServiceImpl dataSourceService) {
        super(NAME, transportService, actionFilters, UpdateDataSourceActionRequest::new);
        this.dataSourceService = dataSourceService;
    }

    protected void doExecute(Task task, UpdateDataSourceActionRequest request, ActionListener<UpdateDataSourceActionResponse> actionListener) {
        try {
            this.dataSourceService.updateDataSource(request.getDataSourceMetadata());
            actionListener.onResponse((Object)new UpdateDataSourceActionResponse("Updated DataSource with name " + request.getDataSourceMetadata().getName()));
        }
        catch (Exception e) {
            actionListener.onFailure(e);
        }
    }
}

