# ----------------------------------------------------------------------------
#
#  Copyright (C) 2018-2022 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


import globdef as G
from PyQt6 import QtGui, QtCore, QtWidgets
from gmsbase import *
from buttonbase import *
from controls import *


class Outputelm (Gmsbase):

    def __init__(self, parent, bstyle, rstyle, callb, index, label): 
        super (Outputelm, self).__init__(parent, callb, index)
        self.resize (G.OP_XS, G.ELM_YS)
        R = Rgainctl (self, rstyle)
        R.move (29, 2)
        R.valueEvent.connect (self.value_event)
        R.show ()
        self.gainctl = R
        L = QtWidgets.QLabel (self)
        L.setFont (G.VAL_FONT)
        L.setText ('Off')
        L.setGeometry (20, 30, G.ELM_XS - 8, 14)
        L.setAlignment (QtCore.Qt.AlignmentFlag.AlignRight)
        self.gaintxt = L
        L = QtWidgets.QLabel (self)
        L.setFont (G.LAB_FONT)
        L.setText (label)
        L.setGeometry (61, 10, G.OP_XS - 65, 20)
        L.setAlignment (QtCore.Qt.AlignmentFlag.AlignLeft)
        y = G.ELM_YS // 2 + 1
        self.bmute = ButtonBase (self, bstyle, True, 0)
        self.bmute.set_text ("M")
        self.bmute.move (6, y - 17)
        self.bmute.bpressEvent.connect (self.mute_event)
        self.bsolo = ButtonBase (self, bstyle, True, 1)
        self.bsolo.set_text ("S")
        self.bsolo.move (6, y + 1)
        self.bsolo.bpressEvent.connect (self.solo_event)

     
        
class Outputwin (QtWidgets.QWidget):

    def __init__(self, parent, nelm, callb, labels = None): 
        super (Outputwin, self).__init__(parent)
        self.nelm = nelm
        self.xs = G.OP_XS
        self.ys = nelm * (G.ELM_YS + 1) + 1
        self.resize (self.xs, self.ys)
        pal = self.palette () 
        bgc = pal.color (pal.ColorRole.Window)
        bstyle = ButtonStyle (17, 17, bgc, [G.FG_N,G.COL5,G.COL2], [G.MK_N,G.COL0,G.COL9], G.BUT_FONT, 9)
        rstyle = RotaryStyle (11, bgc, [G.FG_N,G.COL4], [G.MK_N,G.COL0])
        self.controls = [ None for i in range (nelm) ]
        y = 1
        for i in range (nelm):
            label = '%d' % (i,) if labels is None else labels [i]
            E = Outputelm (self, bstyle, rstyle, callb, i, label)  
            E.move (0, y)
            self.controls [i] = E
            y += G.ELM_YS + 1

    def get_state (self, elm):
        return self.controls [elm].get_state ()

    def set_state (self, elm, gaindb, mute):
        return self.controls [elm].set_state (gaindb, mute)

    def get_solo (self, elm):
        return self.controls [elm].get_solo ()

    def any_solo (self):
        for E in self.controls:
            if E.get_solo (): return True
        return False    

    def exc_solo (self, elm):
        for i in range (self.nelm):
            if i != elm: self.controls [i].solo_off ()

    def paintEvent(self, E):
        qp = QtGui.QPainter(self)
        qp.setRenderHint (QtGui.QPainter.RenderHint.Antialiasing)
        qp.setBrush (QtCore.Qt.BrushStyle.NoBrush)
        qp.setPen (QtGui.QPen (G.MK_N, 0.2))
        qp.translate (0.5, 0.5)
        y = 0
        for i in range (self.nelm + 1):
            qp.drawLine (0, y, self.xs, y)
            y += G.ELM_YS + 1

