"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateInlayHints = void 0;
const sveltekit_1 = require("./sveltekit");
function decorateInlayHints(ls, info, ts, logger) {
    const provideInlayHints = ls.provideInlayHints;
    ls.provideInlayHints = (fileName, span, preferences) => {
        const result = (0, sveltekit_1.getVirtualLS)(fileName, info, ts);
        if (!result) {
            return provideInlayHints(fileName, span, preferences);
        }
        const { languageService, toVirtualPos, toOriginalPos } = result;
        return languageService
            .provideInlayHints(fileName, {
            start: toVirtualPos(span.start),
            length: span.length
        }, preferences)
            .map((hint) => ({
            ...hint,
            position: toOriginalPos(hint.position).pos
        }));
    };
}
exports.decorateInlayHints = decorateInlayHints;
//# sourceMappingURL=inlay-hints.js.map