/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.ui;

import java.text.Format;
import java.util.Objects;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberPercentRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public class HeapViewerNumberRenderer
extends NumberPercentRenderer {
    private final DataType dataType;

    public static HeapViewerNumberRenderer decimalInstance(DataType dataType) {
        return new HeapViewerNumberRenderer(null, dataType);
    }

    public static HeapViewerNumberRenderer bytesInstance(DataType dataType) {
        return new HeapViewerNumberRenderer(Formatters.bytesFormat(), dataType);
    }

    private HeapViewerNumberRenderer(Format format, DataType dataType) {
        super(HeapViewerNumberRenderer.createNumberRenderer(format, dataType));
        this.dataType = dataType;
    }

    public void setValue(Object value, int row) {
        super.setValue(value, row);
        boolean showsPercents = !this.isDiffMode() && !Objects.equals(value, this.dataType.getNoValue()) && !Objects.equals(value, this.dataType.getUnsupportedValue()) && !Objects.equals(value, this.dataType.getNotAvailableValue());
        this.valueRenderers()[1].getComponent().setVisible(showsPercents);
    }

    private static ProfilerRenderer createNumberRenderer(Format customFormat, final DataType dataType) {
        NumberRenderer numberRenderer = new NumberRenderer(customFormat){

            protected String getValueString(Object value, int row, Format format) {
                if (Objects.equals(value, dataType.getNoValue())) {
                    return "-";
                }
                if (Objects.equals(value, dataType.getUnsupportedValue())) {
                    return "";
                }
                if (Objects.equals(value, dataType.getNotAvailableValue())) {
                    return "n/a";
                }
                return super.getValueString(value, row, format);
            }
        };
        numberRenderer.setMargin(3, 3, 3, 3);
        return numberRenderer;
    }
}

