/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.utils;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.core.network.utils.IpAddressUtilsFilter;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class IpAddressUtils {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$");
    private static final RequestProcessor RP = new RequestProcessor("DNSBackgroundResolvers", 10);
    private static IpAddressUtils INSTANCE;

    IpAddressUtils() {
    }

    private static synchronized IpAddressUtils getDefault() {
        if (INSTANCE == null && (INSTANCE = (IpAddressUtils)Lookup.getDefault().lookup(IpAddressUtils.class)) == null) {
            INSTANCE = new IpAddressUtils();
        }
        return INSTANCE;
    }

    @NonNull
    public static InetAddress[] nameResolveArr(String string, int n, IpTypePreference ipTypePreference) throws InterruptedException, UnknownHostException, TimeoutException {
        if (IpAddressUtils.looksLikeIpv6Literal(string) || IpAddressUtils.looksLikeIpv4Literal(string)) {
            InetAddress inetAddress = InetAddress.getByName(string);
            if (ipTypePreference == IpTypePreference.IPV4_ONLY && inetAddress instanceof Inet6Address) {
                throw new UnknownHostException("Mismatch between supplied literal IP address \"" + string + "\" (which is IPv6) and value of ipTypePref : " + (Object)((Object)ipTypePreference));
            }
            if (ipTypePreference == IpTypePreference.IPV6_ONLY && inetAddress instanceof Inet4Address) {
                throw new UnknownHostException("Mismatch between supplied literal IP address \"" + string + "\" (which is IPv6) and value of ipTypePref : " + (Object)((Object)ipTypePreference));
            }
            return new InetAddress[]{inetAddress};
        }
        Callable<InetAddress[]> callable = IpAddressUtils.getDefault().createDnsTimeoutTask(string);
        Future future = RP.submit(callable);
        try {
            InetAddress[] inetAddressArray = n == 0 ? (InetAddress[])future.get() : (InetAddress[])future.get(n, TimeUnit.MILLISECONDS);
            List<InetAddress> list = IpAddressUtilsFilter.filterInetAddresses(Arrays.asList(inetAddressArray), ipTypePreference);
            if (list.isEmpty()) {
                throw new UnknownHostException("A positive result was returned from name lookup for \"" + string + "\" but none that matched a filter of " + (Object)((Object)ipTypePreference));
            }
            return list.toArray(new InetAddress[list.size()]);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof UnknownHostException) {
                throw (UnknownHostException)throwable;
            }
            Exceptions.printStackTrace((Throwable)throwable);
            return new InetAddress[0];
        }
        catch (TimeoutException timeoutException) {
            future.cancel(true);
            throw new TimeoutException("No answer from name service within " + n + " milliseconds when resolving \"" + string + "\"");
        }
    }

    @NonNull
    public static InetAddress nameResolve(String string, int n, IpTypePreference ipTypePreference) throws InterruptedException, UnknownHostException, TimeoutException {
        InetAddress[] inetAddressArray = IpAddressUtils.nameResolveArr(string, n, ipTypePreference);
        return inetAddressArray[0];
    }

    @NonNull
    public static InetAddress nameResolve(String string, int n) throws InterruptedException, UnknownHostException, TimeoutException {
        return IpAddressUtils.nameResolve(string, n, IpTypePreference.ANY_JDK_PREF);
    }

    public static boolean isValidIpv4Address(String string) {
        if (IPV4_PATTERN.matcher(string).matches()) {
            String[] stringArray = string.split("\\.");
            if (stringArray.length != 4) {
                return false;
            }
            for (String string2 : stringArray) {
                if (string2 == null || string2.length() == 0) {
                    return false;
                }
                if (string2.length() > 1 && string2.startsWith("0")) {
                    return false;
                }
                try {
                    int n = Integer.parseInt(string2);
                    if (n <= 255) continue;
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean looksLikeIpv6Literal(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < 3 || string.length() > 39) {
            return false;
        }
        if (string.startsWith(":") || string.endsWith(":")) {
            return true;
        }
        return string.length() >= 5 && (string.charAt(3) == ':' || string.charAt(4) == ':');
    }

    public static boolean looksLikeIpv4Literal(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (!IpAddressUtils.isAsciiDigit(string.charAt(0))) {
            return false;
        }
        int n = string.indexOf(46);
        if (n > 0 && n < string.length() - 1 && n <= 3) {
            for (int i = 0; i < n; ++i) {
                if (IpAddressUtils.isAsciiDigit(string.charAt(i))) continue;
                return false;
            }
            return IpAddressUtils.isAsciiDigit(string.charAt(n + 1));
        }
        return false;
    }

    public static String removeDomain(String string) {
        if (string == null) {
            return string;
        }
        if (IpAddressUtils.looksLikeIpv4Literal(string)) {
            return string;
        }
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf(58);
        if (n2 >= 0 && n2 < n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static void removeLoopback(List<InetAddress> list) {
        if (list == null) {
            return;
        }
        Iterator<InetAddress> iterator = list.iterator();
        while (iterator.hasNext()) {
            InetAddress inetAddress = iterator.next();
            if (!inetAddress.isLoopbackAddress()) continue;
            iterator.remove();
        }
    }

    public static void sortIpAddresses(List<InetAddress> list, boolean bl) {
        IpAddressUtils.sortIpAddresses0(list, bl, false);
    }

    public static void sortIpAddressesShallow(List<InetAddress> list, boolean bl) {
        IpAddressUtils.sortIpAddresses0(list, bl, true);
    }

    private static void sortIpAddresses0(List<InetAddress> list, boolean bl, boolean bl2) {
        if (list != null && list.size() > 1) {
            Collections.sort(list, new InetAddressComparator(bl, bl2));
        }
    }

    private static boolean isAsciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    Callable<InetAddress[]> createDnsTimeoutTask(String string) {
        return new DnsTimeoutTask(string);
    }

    private static class InetAddressComparator
    implements Comparator<InetAddress> {
        private final boolean ip4BeforeIp6;
        private final boolean shallow;

        public InetAddressComparator(boolean bl, boolean bl2) {
            this.ip4BeforeIp6 = bl;
            this.shallow = bl2;
        }

        @Override
        public int compare(InetAddress inetAddress, InetAddress inetAddress2) {
            byte[] byArray = inetAddress.getAddress();
            byte[] byArray2 = inetAddress2.getAddress();
            if (inetAddress instanceof Inet4Address && inetAddress2 instanceof Inet6Address) {
                return this.ip4BeforeIp6 ? -1 : 1;
            }
            if (inetAddress instanceof Inet6Address && inetAddress2 instanceof Inet4Address) {
                return this.ip4BeforeIp6 ? 1 : -1;
            }
            if (byArray.length != byArray2.length) {
                if (byArray.length < byArray2.length) {
                    return this.ip4BeforeIp6 ? -1 : 1;
                }
                return this.ip4BeforeIp6 ? 1 : -1;
            }
            if (this.shallow) {
                return 0;
            }
            for (int i = 0; i < byArray.length; ++i) {
                int n;
                int n2 = Byte.toUnsignedInt(byArray[i]);
                if (n2 == (n = Byte.toUnsignedInt(byArray2[i]))) continue;
                if (n2 < n) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private static class DnsTimeoutTask
    implements Callable<InetAddress[]> {
        private final String host;

        public DnsTimeoutTask(String string) {
            this.host = string;
        }

        @Override
        public InetAddress[] call() throws UnknownHostException {
            return InetAddress.getAllByName(this.host);
        }
    }

    public static enum IpTypePreference {
        IPV4_ONLY,
        IPV6_ONLY,
        ANY_IPV4_PREF,
        ANY_IPV6_PREF,
        ANY_JDK_PREF;

    }
}

