/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.knn.plugin.transport.GetModelAction;
import org.opensearch.knn.plugin.transport.GetModelRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestGetModelHandler
extends BaseRestHandler {
    private static final String NAME = "knn_get_model_action";

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_knn", "models", "model_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String modelID = restRequest.param("model_id");
        if (StringUtils.isBlank((String)modelID)) {
            throw new IllegalArgumentException("model ID cannot be empty");
        }
        GetModelRequest getModelRequest = new GetModelRequest(modelID);
        return channel -> client.execute((ActionType)GetModelAction.INSTANCE, (ActionRequest)getModelRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

