/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.validation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.DefaultObjectMapper;

public abstract class AbstractConfigurationValidator {
    JsonFactory factory = new JsonFactory();
    public static final String INVALID_KEYS_KEY = "invalid_keys";
    public static final String MISSING_MANDATORY_KEYS_KEY = "missing_mandatory_keys";
    public static final String MISSING_MANDATORY_OR_KEYS_KEY = "specify_one_of";
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final Map<String, DataType> allowedKeys = new HashMap<String, DataType>();
    protected final Set<String> mandatoryKeys = new HashSet<String>();
    protected final Set<String> mandatoryOrKeys = new HashSet<String>();
    protected final Map<String, String> wrongDatatypes = new HashMap<String, String>();
    protected final Set<String> missingMandatoryKeys = new HashSet<String>();
    protected final Set<String> invalidKeys = new HashSet<String>();
    protected final Set<String> missingMandatoryOrKeys = new HashSet<String>();
    protected ErrorType errorType = ErrorType.NONE;
    protected boolean payloadMandatory = false;
    protected boolean payloadAllowed = true;
    protected final RestRequest.Method method;
    protected final BytesReference content;
    protected final Settings opensearchSettings;
    protected final RestRequest request;
    protected final Object[] param;
    private JsonNode contentAsNode;

    public AbstractConfigurationValidator(RestRequest request, BytesReference ref, Settings opensearchSettings, Object ... param) {
        this.content = ref;
        this.method = request.method();
        this.opensearchSettings = opensearchSettings;
        this.request = request;
        this.param = param;
    }

    public JsonNode getContentAsNode() {
        return this.contentAsNode;
    }

    public boolean validate() {
        boolean valid;
        if (this.method.equals((Object)RestRequest.Method.DELETE) || this.method.equals((Object)RestRequest.Method.GET)) {
            return true;
        }
        if (this.payloadMandatory && this.content.length() == 0) {
            this.errorType = ErrorType.PAYLOAD_MANDATORY;
            return false;
        }
        if (!this.payloadMandatory && this.content.length() == 0) {
            return true;
        }
        if (this.payloadMandatory && this.content.length() > 0) {
            try {
                if (DefaultObjectMapper.readTree(this.content.utf8ToString()).size() == 0) {
                    this.errorType = ErrorType.PAYLOAD_MANDATORY;
                    return false;
                }
            }
            catch (IOException e) {
                this.log.error(ErrorType.BODY_NOT_PARSEABLE.toString(), (Throwable)e);
                this.errorType = ErrorType.BODY_NOT_PARSEABLE;
                return false;
            }
        }
        if (!this.payloadAllowed && this.content.length() > 0) {
            this.errorType = ErrorType.PAYLOAD_NOT_ALLOWED;
            return false;
        }
        HashSet requested = new HashSet();
        try {
            this.contentAsNode = DefaultObjectMapper.readTree(this.content.utf8ToString());
            requested.addAll(ImmutableList.copyOf((Iterator)this.contentAsNode.fieldNames()));
        }
        catch (Exception e) {
            this.log.error(ErrorType.BODY_NOT_PARSEABLE.toString(), (Throwable)e);
            this.errorType = ErrorType.BODY_NOT_PARSEABLE;
            return false;
        }
        if (Collections.disjoint(requested, this.mandatoryOrKeys)) {
            this.missingMandatoryOrKeys.addAll(this.mandatoryOrKeys);
        }
        HashSet<String> mandatory = new HashSet<String>(this.mandatoryKeys);
        mandatory.removeAll(requested);
        this.missingMandatoryKeys.addAll(mandatory);
        HashSet<String> allowed = new HashSet<String>(this.allowedKeys.keySet());
        requested.removeAll(allowed);
        this.invalidKeys.addAll(requested);
        boolean bl = valid = this.missingMandatoryKeys.isEmpty() && this.invalidKeys.isEmpty() && this.missingMandatoryOrKeys.isEmpty();
        if (!valid) {
            this.errorType = ErrorType.INVALID_CONFIGURATION;
        }
        try {
            if (!this.checkDatatypes()) {
                this.errorType = ErrorType.WRONG_DATATYPE;
                return false;
            }
        }
        catch (Exception e) {
            this.log.error(ErrorType.BODY_NOT_PARSEABLE.toString(), (Throwable)e);
            this.errorType = ErrorType.BODY_NOT_PARSEABLE;
            return false;
        }
        for (Map.Entry<String, DataType> allowedKey : this.allowedKeys.entrySet()) {
            JsonNode value = this.contentAsNode.get(allowedKey.getKey());
            if (value == null || !this.hasNullArrayElement(value)) continue;
            this.errorType = ErrorType.NULL_ARRAY_ELEMENT;
            return false;
        }
        return valid;
    }

    private boolean checkDatatypes() throws Exception {
        String contentAsJson = XContentHelper.convertToJson((BytesReference)this.content, (boolean)false, (MediaType)XContentType.JSON);
        try (JsonParser parser = this.factory.createParser(contentAsJson);){
            JsonToken token = null;
            while ((token = parser.nextToken()) != null) {
                String currentName;
                DataType dataType;
                if (!token.equals((Object)JsonToken.FIELD_NAME) || (dataType = this.allowedKeys.get(currentName = parser.getCurrentName())) == null) continue;
                JsonToken valueToken = parser.nextToken();
                switch (dataType) {
                    case STRING: {
                        if (valueToken.equals((Object)JsonToken.VALUE_STRING)) break;
                        this.wrongDatatypes.put(currentName, "String expected");
                        break;
                    }
                    case ARRAY: {
                        if (valueToken.equals((Object)JsonToken.START_ARRAY) || valueToken.equals((Object)JsonToken.END_ARRAY)) break;
                        this.wrongDatatypes.put(currentName, "Array expected");
                        break;
                    }
                    case OBJECT: {
                        if (valueToken.equals((Object)JsonToken.START_OBJECT) || valueToken.equals((Object)JsonToken.END_OBJECT)) break;
                        this.wrongDatatypes.put(currentName, "Object expected");
                    }
                }
            }
            boolean bl = this.wrongDatatypes.isEmpty();
            return bl;
        }
    }

    public XContentBuilder errorsAsXContent(RestChannel channel) {
        try {
            XContentBuilder builder = channel.newBuilder();
            builder.startObject();
            switch (this.errorType) {
                case NONE: {
                    builder.field("status", "error");
                    builder.field("reason", this.errorType.getMessage());
                    break;
                }
                case INVALID_CONFIGURATION: {
                    builder.field("status", "error");
                    builder.field("reason", ErrorType.INVALID_CONFIGURATION.getMessage());
                    this.addErrorMessage(builder, INVALID_KEYS_KEY, this.invalidKeys);
                    this.addErrorMessage(builder, MISSING_MANDATORY_KEYS_KEY, this.missingMandatoryKeys);
                    this.addErrorMessage(builder, MISSING_MANDATORY_OR_KEYS_KEY, this.missingMandatoryKeys);
                    break;
                }
                case INVALID_PASSWORD: {
                    builder.field("status", "error");
                    builder.field("reason", this.opensearchSettings.get("plugins.security.restapi.password_validation_error_message", "Password does not match minimum criteria"));
                    break;
                }
                case WEAK_PASSWORD: 
                case SIMILAR_PASSWORD: {
                    builder.field("status", "error");
                    builder.field("reason", this.opensearchSettings.get("plugins.security.restapi.password_validation_error_message", this.errorType.message));
                    break;
                }
                case WRONG_DATATYPE: {
                    builder.field("status", "error");
                    builder.field("reason", ErrorType.WRONG_DATATYPE.getMessage());
                    for (Map.Entry<String, String> entry : this.wrongDatatypes.entrySet()) {
                        builder.field(entry.getKey(), entry.getValue());
                    }
                    break;
                }
                case NULL_ARRAY_ELEMENT: {
                    builder.field("status", "error");
                    builder.field("reason", ErrorType.NULL_ARRAY_ELEMENT.getMessage());
                    break;
                }
                default: {
                    builder.field("status", "error");
                    builder.field("reason", this.errorType.getMessage());
                }
            }
            builder.endObject();
            return builder;
        }
        catch (IOException ex) {
            this.log.error("Cannot build error settings", (Throwable)ex);
            return null;
        }
    }

    private void addErrorMessage(XContentBuilder builder, String message, Set<String> keys) throws IOException {
        if (!keys.isEmpty()) {
            builder.startObject(message);
            builder.field("keys", Joiner.on((String)",").join((Object[])keys.toArray(new String[0])));
            builder.endObject();
        }
    }

    protected final boolean hasParams() {
        return this.param != null && this.param.length > 0;
    }

    private boolean hasNullArrayElement(JsonNode node) {
        for (JsonNode element : node) {
            if (!(element.isNull() ? node.isArray() : element.isContainerNode() && this.hasNullArrayElement(element))) continue;
            return true;
        }
        return false;
    }

    public static enum ErrorType {
        NONE("ok"),
        INVALID_CONFIGURATION("Invalid configuration"),
        INVALID_PASSWORD("Invalid password"),
        WEAK_PASSWORD("Weak password"),
        SIMILAR_PASSWORD("Password is similar to user name"),
        WRONG_DATATYPE("Wrong datatype"),
        BODY_NOT_PARSEABLE("Could not parse content of request."),
        PAYLOAD_NOT_ALLOWED("Request body not allowed for this action."),
        PAYLOAD_MANDATORY("Request body required for this action."),
        SECURITY_NOT_INITIALIZED("Security index not initialized"),
        NULL_ARRAY_ELEMENT("`null` is not allowed as json array element");

        private String message;

        private ErrorType(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum DataType {
        STRING,
        ARRAY,
        OBJECT,
        BOOLEAN;

    }
}

