from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Adaptor3d import *
from OCC.Core.Geom import *
from OCC.Core.gp import *
from OCC.Core.GeomAbs import *
from OCC.Core.TColStd import *


class geomadaptor:
    @staticmethod
    def MakeCurve(C: Adaptor3d_Curve) -> Geom_Curve: ...
    @staticmethod
    def MakeSurface(theS: Adaptor3d_Surface, theTrimFlag: Optional[bool] = True) -> Geom_Surface: ...

class GeomAdaptor_Curve(Adaptor3d_Curve):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theCurve: Geom_Curve) -> None: ...
    @overload
    def __init__(self, theCurve: Geom_Curve, theUFirst: float, theULast: float) -> None: ...
    def BSpline(self) -> Geom_BSplineCurve: ...
    def Bezier(self) -> Geom_BezierCurve: ...
    def Circle(self) -> gp_Circ: ...
    def Continuity(self) -> GeomAbs_Shape: ...
    def Curve(self) -> Geom_Curve: ...
    def D0(self, U: float, P: gp_Pnt) -> None: ...
    def D1(self, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
    def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
    def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
    def DN(self, U: float, N: int) -> gp_Vec: ...
    def Degree(self) -> int: ...
    def Ellipse(self) -> gp_Elips: ...
    def FirstParameter(self) -> float: ...
    def GetType(self) -> GeomAbs_CurveType: ...
    def Hyperbola(self) -> gp_Hypr: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsClosed(self) -> bool: ...
    def IsPeriodic(self) -> bool: ...
    def IsRational(self) -> bool: ...
    def LastParameter(self) -> float: ...
    def Line(self) -> gp_Lin: ...
    @overload
    def Load(self, theCurve: Geom_Curve) -> None: ...
    @overload
    def Load(self, theCurve: Geom_Curve, theUFirst: float, theULast: float) -> None: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def NbKnots(self) -> int: ...
    def NbPoles(self) -> int: ...
    def OffsetCurve(self) -> Geom_OffsetCurve: ...
    def Parabola(self) -> gp_Parab: ...
    def Period(self) -> float: ...
    def Reset(self) -> None: ...
    def Resolution(self, R3d: float) -> float: ...
    def Trim(self, First: float, Last: float, Tol: float) -> Adaptor3d_Curve: ...
    def Value(self, U: float) -> gp_Pnt: ...

class GeomAdaptor_Surface(Adaptor3d_Surface):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theSurf: Geom_Surface) -> None: ...
    @overload
    def __init__(self, theSurf: Geom_Surface, theUFirst: float, theULast: float, theVFirst: float, theVLast: float, theTolU: Optional[float] = 0.0, theTolV: Optional[float] = 0.0) -> None: ...
    def AxeOfRevolution(self) -> gp_Ax1: ...
    def BSpline(self) -> Geom_BSplineSurface: ...
    def BasisCurve(self) -> Adaptor3d_Curve: ...
    def BasisSurface(self) -> Adaptor3d_Surface: ...
    def Bezier(self) -> Geom_BezierSurface: ...
    def Cone(self) -> gp_Cone: ...
    def Cylinder(self) -> gp_Cylinder: ...
    def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
    def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
    def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
    def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
    def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
    def Direction(self) -> gp_Dir: ...
    def FirstUParameter(self) -> float: ...
    def FirstVParameter(self) -> float: ...
    def GetType(self) -> GeomAbs_SurfaceType: ...
    def IsUClosed(self) -> bool: ...
    def IsUPeriodic(self) -> bool: ...
    def IsURational(self) -> bool: ...
    def IsVClosed(self) -> bool: ...
    def IsVPeriodic(self) -> bool: ...
    def IsVRational(self) -> bool: ...
    def LastUParameter(self) -> float: ...
    def LastVParameter(self) -> float: ...
    @overload
    def Load(self, theSurf: Geom_Surface) -> None: ...
    @overload
    def Load(self, theSurf: Geom_Surface, theUFirst: float, theULast: float, theVFirst: float, theVLast: float, theTolU: Optional[float] = 0.0, theTolV: Optional[float] = 0.0) -> None: ...
    def NbUIntervals(self, S: GeomAbs_Shape) -> int: ...
    def NbUKnots(self) -> int: ...
    def NbUPoles(self) -> int: ...
    def NbVIntervals(self, S: GeomAbs_Shape) -> int: ...
    def NbVKnots(self) -> int: ...
    def NbVPoles(self) -> int: ...
    def OffsetValue(self) -> float: ...
    def Plane(self) -> gp_Pln: ...
    def Sphere(self) -> gp_Sphere: ...
    def Surface(self) -> Geom_Surface: ...
    def Torus(self) -> gp_Torus: ...
    def UContinuity(self) -> GeomAbs_Shape: ...
    def UDegree(self) -> int: ...
    def UIntervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def UPeriod(self) -> float: ...
    def UResolution(self, R3d: float) -> float: ...
    def UTrim(self, First: float, Last: float, Tol: float) -> Adaptor3d_Surface: ...
    def VContinuity(self) -> GeomAbs_Shape: ...
    def VDegree(self) -> int: ...
    def VIntervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def VPeriod(self) -> float: ...
    def VResolution(self, R3d: float) -> float: ...
    def VTrim(self, First: float, Last: float, Tol: float) -> Adaptor3d_Surface: ...
    def Value(self, U: float, V: float) -> gp_Pnt: ...

class GeomAdaptor_SurfaceOfLinearExtrusion(GeomAdaptor_Surface):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve, V: gp_Dir) -> None: ...
    def AxeOfRevolution(self) -> gp_Ax1: ...
    def BSpline(self) -> Geom_BSplineSurface: ...
    def BasisCurve(self) -> Adaptor3d_Curve: ...
    def Bezier(self) -> Geom_BezierSurface: ...
    def Cone(self) -> gp_Cone: ...
    def Cylinder(self) -> gp_Cylinder: ...
    def Direction(self) -> gp_Dir: ...
    def FirstUParameter(self) -> float: ...
    def FirstVParameter(self) -> float: ...
    def GetType(self) -> GeomAbs_SurfaceType: ...
    def IsUClosed(self) -> bool: ...
    def IsUPeriodic(self) -> bool: ...
    def IsURational(self) -> bool: ...
    def IsVClosed(self) -> bool: ...
    def IsVPeriodic(self) -> bool: ...
    def IsVRational(self) -> bool: ...
    def LastUParameter(self) -> float: ...
    def LastVParameter(self) -> float: ...
    @overload
    def Load(self, C: Adaptor3d_Curve) -> None: ...
    @overload
    def Load(self, V: gp_Dir) -> None: ...
    def NbUIntervals(self, S: GeomAbs_Shape) -> int: ...
    def NbUPoles(self) -> int: ...
    def NbVIntervals(self, S: GeomAbs_Shape) -> int: ...
    def Plane(self) -> gp_Pln: ...
    def Sphere(self) -> gp_Sphere: ...
    def Torus(self) -> gp_Torus: ...
    def UContinuity(self) -> GeomAbs_Shape: ...
    def UDegree(self) -> int: ...
    def UIntervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def UPeriod(self) -> float: ...
    def UResolution(self, R3d: float) -> float: ...
    def UTrim(self, First: float, Last: float, Tol: float) -> Adaptor3d_Surface: ...
    def VContinuity(self) -> GeomAbs_Shape: ...
    def VIntervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def VPeriod(self) -> float: ...
    def VResolution(self, R3d: float) -> float: ...
    def VTrim(self, First: float, Last: float, Tol: float) -> Adaptor3d_Surface: ...

class GeomAdaptor_SurfaceOfRevolution(GeomAdaptor_Surface):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve, V: gp_Ax1) -> None: ...
    def AxeOfRevolution(self) -> gp_Ax1: ...
    def Axis(self) -> gp_Ax3: ...
    def BSpline(self) -> Geom_BSplineSurface: ...
    def BasisCurve(self) -> Adaptor3d_Curve: ...
    def Bezier(self) -> Geom_BezierSurface: ...
    def Cone(self) -> gp_Cone: ...
    def Cylinder(self) -> gp_Cylinder: ...
    def FirstUParameter(self) -> float: ...
    def FirstVParameter(self) -> float: ...
    def GetType(self) -> GeomAbs_SurfaceType: ...
    def IsUClosed(self) -> bool: ...
    def IsUPeriodic(self) -> bool: ...
    def IsURational(self) -> bool: ...
    def IsVClosed(self) -> bool: ...
    def IsVPeriodic(self) -> bool: ...
    def IsVRational(self) -> bool: ...
    def LastUParameter(self) -> float: ...
    def LastVParameter(self) -> float: ...
    @overload
    def Load(self, C: Adaptor3d_Curve) -> None: ...
    @overload
    def Load(self, V: gp_Ax1) -> None: ...
    def NbUIntervals(self, S: GeomAbs_Shape) -> int: ...
    def NbVIntervals(self, S: GeomAbs_Shape) -> int: ...
    def NbVKnots(self) -> int: ...
    def NbVPoles(self) -> int: ...
    def Plane(self) -> gp_Pln: ...
    def Sphere(self) -> gp_Sphere: ...
    def Torus(self) -> gp_Torus: ...
    def UContinuity(self) -> GeomAbs_Shape: ...
    def UIntervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def UPeriod(self) -> float: ...
    def UResolution(self, R3d: float) -> float: ...
    def UTrim(self, First: float, Last: float, Tol: float) -> Adaptor3d_Surface: ...
    def VContinuity(self) -> GeomAbs_Shape: ...
    def VDegree(self) -> int: ...
    def VIntervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def VPeriod(self) -> float: ...
    def VResolution(self, R3d: float) -> float: ...
    def VTrim(self, First: float, Last: float, Tol: float) -> Adaptor3d_Surface: ...

# harray1 classes
# harray2 classes
# hsequence classes

geomadaptor_MakeCurve = geomadaptor.MakeCurve
geomadaptor_MakeSurface = geomadaptor.MakeSurface
