/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.PatchableResourceApiAction;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.dlic.rest.validation.NodesDnValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.NodesDn;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.threadpool.ThreadPool;

public class NodesDnApiAction
extends PatchableResourceApiAction {
    public static final String STATIC_OPENSEARCH_YML_NODES_DN = "STATIC_OPENSEARCH_YML_NODES_DN";
    private final List<String> staticNodesDnFromEsYml;
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/nodesdn/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/nodesdn/"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/nodesdn/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/nodesdn/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/nodesdn/"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/nodesdn/{name}")));

    @Inject
    public NodesDnApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
        this.staticNodesDnFromEsYml = settings.getAsList("plugins.security.nodes_dn", Collections.emptyList());
    }

    @Override
    protected boolean hasPermissionsToCreate(SecurityDynamicConfiguration<?> dynamicConfigFactory, Object content, String resourceName) {
        return true;
    }

    public List<RestHandler.Route> routes() {
        if (this.settings.getAsBoolean("plugins.security.nodes_dn_dynamic_config_enabled", Boolean.valueOf(false)).booleanValue()) {
            return routes;
        }
        return Collections.emptyList();
    }

    @Override
    protected void handleApiRequest(RestChannel channel, RestRequest request, Client client) throws IOException {
        if (!this.isSuperAdmin()) {
            this.forbidden(channel, "API allowed only for admin.");
            return;
        }
        super.handleApiRequest(channel, request, client);
    }

    @Override
    protected void consumeParameters(RestRequest request) {
        request.param("name");
        request.param("show_all");
    }

    @Override
    protected boolean isReadOnly(SecurityDynamicConfiguration<?> existingConfiguration, String name) {
        if (STATIC_OPENSEARCH_YML_NODES_DN.equals(name)) {
            return true;
        }
        return super.isReadOnly(existingConfiguration, name);
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        String resourcename = request.param("name");
        SecurityDynamicConfiguration<?> configuration = this.load(this.getConfigName(), true);
        this.filter(configuration);
        if (resourcename == null || resourcename.length() == 0) {
            Boolean showAll = request.paramAsBoolean("show_all", Boolean.FALSE);
            if (showAll.booleanValue()) {
                this.putStaticEntry(configuration);
            }
            this.successResponse(channel, configuration);
            return;
        }
        if (!configuration.exists(resourcename)) {
            this.notFound(channel, "Resource '" + resourcename + "' not found.");
            return;
        }
        configuration.removeOthers(resourcename);
        this.successResponse(channel, configuration);
    }

    private void putStaticEntry(SecurityDynamicConfiguration<?> configuration) {
        if (!NodesDn.class.equals(configuration.getImplementingClass())) {
            throw new RuntimeException("Unknown class type - " + configuration.getImplementingClass());
        }
        NodesDn nodesDn = new NodesDn();
        nodesDn.setNodesDn(this.staticNodesDnFromEsYml);
        configuration.putCEntry(STATIC_OPENSEARCH_YML_NODES_DN, nodesDn);
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.NODESDN;
    }

    @Override
    protected String getResourceName() {
        return "nodesdn";
    }

    @Override
    protected CType getConfigName() {
        return CType.NODESDN;
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... params) {
        return new NodesDnValidator(request, ref, this.settings, params);
    }
}

