/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.HeapFragment;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.truffle.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.netbeans.api.progress.ProgressHandle;

public abstract class TruffleLanguageHeapFragment<O extends TruffleObject, T extends TruffleType<O>>
extends HeapFragment {
    private final TruffleLanguage<O, T, ? extends TruffleLanguageHeapFragment<O, T>> language;
    private long heapSize;
    private long objectsCount;
    private List<T> types;
    private final Object statisticsLock = new Object();
    private Progress statisticsProgress;
    private boolean ownProgress;
    private final Object statisticsProgressLock = new Object();

    protected TruffleLanguageHeapFragment(String ID, String name, String description, TruffleLanguage<O, T, ? extends TruffleLanguageHeapFragment<O, T>> language, Heap heap) {
        super(ID, name, description, heap);
        this.language = language;
    }

    public static boolean isTruffleHeap(HeapContext context) {
        return context.getFragment() instanceof TruffleLanguageHeapFragment;
    }

    public long getHeapSize(Progress progress) {
        this.checkInitialized(progress);
        return this.heapSize;
    }

    public long getObjectsCount(Progress progress) {
        this.checkInitialized(progress);
        return this.objectsCount;
    }

    public List<T> getTypes(Progress progress) {
        this.checkInitialized(progress);
        return this.types;
    }

    public T getType(String name, Progress progress) {
        List<T> _types = this.getTypes(progress);
        for (TruffleType type : _types) {
            if (!name.equals(type.getName())) continue;
            return (T)type;
        }
        return null;
    }

    public abstract Iterator<Instance> getInstancesIterator();

    public Iterator<O> getObjectsIterator() {
        return new ObjectsIterator(this.getInstancesIterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialized(final Progress progress) {
        Object object;
        Progress.Listener progressListener = null;
        if (progress != null) {
            object = this.statisticsProgressLock;
            synchronized (object) {
                if (this.statisticsProgress != null) {
                    this.statisticsProgress.addChangeListener(new Progress.Listener(){

                        public void progressChanged(Progress.Event event) {
                            progress.setCurrentStep(event.getCurrentStep());
                        }
                    });
                }
            }
        }
        object = this.statisticsLock;
        synchronized (object) {
            if (this.types == null) {
                this.computeStatistics(progress);
            }
        }
        if (progressListener != null) {
            object = this.statisticsProgressLock;
            synchronized (object) {
                if (this.statisticsProgress != null) {
                    this.statisticsProgress.removeChangeListener(progressListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeStatistics(Progress progress) {
        int verIdx;
        if (this.statisticsProgress == null) {
            Object object = this.statisticsProgressLock;
            synchronized (object) {
                if (progress != null) {
                    this.statisticsProgress = progress;
                } else {
                    this.ownProgress = true;
                    this.statisticsProgress = new Progress();
                    this.statisticsProgress.setupUnknownSteps();
                }
            }
        }
        String langName = (verIdx = this.getDescription().indexOf(" (")) != -1 ? this.getDescription().substring(0, verIdx) : Bundle.TruffleLanguageHeapFragment_Language();
        ProgressHandle pHandle = ProgressHandle.createHandle((String)Bundle.TruffleLanguageHeapFragment_InitializingLanguageModel(langName));
        pHandle.setInitialDelay(1000);
        pHandle.start();
        TruffleType.TypesComputer computer = new TruffleType.TypesComputer<O, T>(this.language, this.heap){

            @Override
            protected void addingObject(long size, long retained, String type) {
                TruffleLanguageHeapFragment.this.objectsCount++;
                TruffleLanguageHeapFragment.this.heapSize = TruffleLanguageHeapFragment.this.heapSize + size;
            }
        };
        Iterator<O> objects = this.getObjectsIterator();
        try {
            while (objects.hasNext()) {
                computer.addObject((TruffleObject)objects.next());
                if (this.statisticsProgress == null) continue;
                this.statisticsProgress.step();
            }
        }
        finally {
            if (this.statisticsProgress != null && this.ownProgress) {
                this.statisticsProgress.finish();
            }
            pHandle.finish();
        }
        this.types = computer.getTypes();
    }

    protected final Iterator<Instance> instancesIterator(String javaClassFqn) {
        return HeapUtils.instancesIterator((Collection)HeapUtils.getSubclasses((Heap)this.heap, (String)javaClassFqn));
    }

    protected final Iterator<Instance> instancesIterator(String[] javaClassFqns) {
        ArrayList classes = new ArrayList();
        for (String fqn : javaClassFqns) {
            classes.addAll(HeapUtils.getSubclasses((Heap)this.heap, (String)fqn));
        }
        return HeapUtils.instancesIterator(classes);
    }

    protected static String fragmentDescription(Instance langID, Heap heap) {
        return DetailsSupport.getDetailsString((Instance)langID);
    }

    protected class ObjectsIterator
    implements Iterator<O> {
        private final Iterator<Instance> instancesIter;

        public ObjectsIterator(Iterator<Instance> iter) {
            this.instancesIter = iter;
        }

        public ObjectsIterator(Collection<JavaClass> cls) {
            this.instancesIter = HeapUtils.instancesIterator(cls);
        }

        @Override
        public boolean hasNext() {
            return this.instancesIter.hasNext();
        }

        @Override
        public O next() {
            return TruffleLanguageHeapFragment.this.language.createObject(this.instancesIter.next());
        }
    }
}

