/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util.destinationmigration;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.model.destination.Destination;
import org.opensearch.alerting.model.destination.email.EmailAccount;
import org.opensearch.alerting.model.destination.email.EmailEntry;
import org.opensearch.alerting.model.destination.email.Recipient;
import org.opensearch.alerting.util.DestinationType;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.Chime;
import org.opensearch.commons.notifications.model.ConfigType;
import org.opensearch.commons.notifications.model.Email;
import org.opensearch.commons.notifications.model.EmailGroup;
import org.opensearch.commons.notifications.model.EmailRecipient;
import org.opensearch.commons.notifications.model.HttpMethodType;
import org.opensearch.commons.notifications.model.MethodType;
import org.opensearch.commons.notifications.model.NotificationConfig;
import org.opensearch.commons.notifications.model.Slack;
import org.opensearch.commons.notifications.model.SmtpAccount;
import org.opensearch.commons.notifications.model.Webhook;
import org.opensearch.core.common.Strings;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/alerting/util/destinationmigration/DestinationConversionUtils;", "", "()V", "Companion", "opensearch-alerting"})
public final class DestinationConversionUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/alerting/util/destinationmigration/DestinationConversionUtils$Companion;", "", "()V", "buildUri", "Ljava/net/URI;", "endpoint", "", "scheme", "host", "port", "", "path", "queryParams", "", "convertAlertingToNotificationMethodType", "Lorg/opensearch/commons/notifications/model/MethodType;", "alertMethodType", "Lorg/opensearch/alerting/model/destination/email/EmailAccount$MethodType;", "convertDestinationToNotificationConfig", "Lorg/opensearch/commons/notifications/model/NotificationConfig;", "destination", "Lorg/opensearch/alerting/model/destination/Destination;", "convertEmailAccountToNotificationConfig", "emailAccount", "Lorg/opensearch/alerting/model/destination/email/EmailAccount;", "convertEmailGroupToNotificationConfig", "emailGroup", "Lorg/opensearch/alerting/model/destination/email/EmailGroup;", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final NotificationConfig convertDestinationToNotificationConfig(@NotNull Destination destination) {
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            switch (WhenMappings.$EnumSwitchMapping$0[destination.getType().ordinal()]) {
                case 1: {
                    v0 = destination.getChime();
                    if (v0 == null) {
                        return null;
                    }
                    alertChime = v0;
                    chime = new Chime(alertChime.getUrl());
                    description = "Chime destination created from the Alerting plugin";
                    return new NotificationConfig(destination.getName(), description, ConfigType.CHIME, (BaseConfigData)chime, false, 16, null);
                }
                case 2: {
                    v1 = destination.getSlack();
                    if (v1 == null) {
                        return null;
                    }
                    alertSlack = v1;
                    slack = new Slack(alertSlack.getUrl());
                    description = "Slack destination created from the Alerting plugin";
                    return new NotificationConfig(destination.getName(), description, ConfigType.SLACK, (BaseConfigData)slack, false, 16, null);
                }
                case 3: {
                    v2 = destination.getCustomWebhook();
                    if (v2 == null) {
                        return null;
                    }
                    alertWebhook = v2;
                    uri = String.valueOf(this.buildUri(alertWebhook.getUrl(), alertWebhook.getScheme(), alertWebhook.getHost(), alertWebhook.getPort(), alertWebhook.getPath(), alertWebhook.getQueryParams()));
                    var6_14 = alertWebhook.getMethod();
                    if (var6_14 == null) {
                        v3 = null;
                    } else {
                        var8_17 = Locale.ENGLISH;
                        Intrinsics.checkNotNullExpressionValue((Object)var8_17, (String)"ENGLISH");
                        var9_19 = var6_14.toUpperCase(var8_17);
                        Intrinsics.checkNotNullExpressionValue((Object)var9_19, (String)"this as java.lang.String).toUpperCase(locale)");
                        v3 = var5_21 = var9_19;
                    }
                    if (var5_21 == null) ** GOTO lbl-1000
                    tmp = -1;
                    switch (var5_21.hashCode()) {
                        case 2461856: {
                            if (var5_21.equals("POST")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 79599: {
                            if (var5_21.equals("PUT")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 75900968: {
                            if (var5_21.equals("PATCH")) {
                                tmp = 3;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            v4 = HttpMethodType.POST;
                            break;
                        }
                        case 2: {
                            v4 = HttpMethodType.PUT;
                            break;
                        }
                        case 3: {
                            v4 = HttpMethodType.PATCH;
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v4 = HttpMethodType.POST;
                        }
                    }
                    methodType = v4;
                    webhook = new Webhook(uri, alertWebhook.getHeaderParams(), methodType);
                    description = "Webhook destination created from the Alerting plugin";
                    return new NotificationConfig(destination.getName(), description, ConfigType.WEBHOOK, (BaseConfigData)webhook, false, 16, null);
                }
                case 4: {
                    v5 = destination.getEmail();
                    if (v5 == null) {
                        return null;
                    }
                    alertEmail = v5;
                    recipients = new ArrayList<E>();
                    emailGroupIds = new ArrayList<E>();
                    $this$forEach$iv = alertEmail.getRecipients();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (Recipient)element$iv;
                        $i$a$-forEach-DestinationConversionUtils$Companion$convertDestinationToNotificationConfig$1 = false;
                        if (it.getType() == Recipient.RecipientType.EMAIL_GROUP) {
                            if (it.getEmailGroupID() == null) continue;
                            $i$a$-let-DestinationConversionUtils$Companion$convertDestinationToNotificationConfig$1$1 = false;
                            emailGroupIds.add(emailGroup);
                            continue;
                        }
                        if (it.getEmail() == null) continue;
                        $i$a$-let-DestinationConversionUtils$Companion$convertDestinationToNotificationConfig$1$2 = false;
                        recipients.add(new EmailRecipient(emailRecipient));
                    }
                    email = new Email(alertEmail.getEmailAccountID(), recipients, emailGroupIds);
                    description = "Email destination created from the Alerting plugin";
                    return new NotificationConfig(destination.getName(), description, ConfigType.EMAIL, (BaseConfigData)email, false, 16, null);
                }
            }
            return null;
        }

        @NotNull
        public final NotificationConfig convertEmailAccountToNotificationConfig(@NotNull EmailAccount emailAccount) {
            Intrinsics.checkNotNullParameter((Object)emailAccount, (String)"emailAccount");
            MethodType methodType = this.convertAlertingToNotificationMethodType(emailAccount.getMethod());
            SmtpAccount smtpAccount = new SmtpAccount(emailAccount.getHost(), emailAccount.getPort(), methodType, emailAccount.getEmail());
            String description = "Email account created from the Alerting plugin";
            return new NotificationConfig(emailAccount.getName(), description, ConfigType.SMTP_ACCOUNT, (BaseConfigData)smtpAccount, false, 16, null);
        }

        @NotNull
        public final NotificationConfig convertEmailGroupToNotificationConfig(@NotNull org.opensearch.alerting.model.destination.email.EmailGroup emailGroup) {
            Intrinsics.checkNotNullParameter((Object)emailGroup, (String)"emailGroup");
            List recipients = new ArrayList();
            Iterable $this$forEach$iv = emailGroup.getEmails();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EmailEntry it = (EmailEntry)element$iv;
                boolean bl = false;
                recipients.add(new EmailRecipient(it.getEmail()));
            }
            EmailGroup notificationEmailGroup = new EmailGroup(recipients);
            String description = "Email group created from the Alerting plugin";
            return new NotificationConfig(emailGroup.getName(), description, ConfigType.EMAIL_GROUP, (BaseConfigData)notificationEmailGroup, false, 16, null);
        }

        private final URI buildUri(String endpoint, String scheme, String host, int port, String path, Map<String, String> queryParams) {
            URI uRI;
            try {
                if (Strings.isNullOrEmpty((String)endpoint)) {
                    if (host == null) {
                        throw new IllegalStateException("No host was provided when endpoint was null");
                    }
                    String uriScheme = scheme;
                    if (Strings.isNullOrEmpty((String)scheme)) {
                        uriScheme = "https";
                    }
                    URIBuilder uriBuilder = new URIBuilder();
                    if (!queryParams.isEmpty()) {
                        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                            String key = entry.getKey();
                            String value = entry.getValue();
                            uriBuilder.addParameter(key, value);
                        }
                    }
                    return uriBuilder.setScheme(uriScheme).setHost(host).setPort(port).setPath(path).build();
                }
                uRI = new URIBuilder(endpoint).build();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Error creating URI", e);
            }
            return uRI;
        }

        @NotNull
        public final MethodType convertAlertingToNotificationMethodType(@NotNull EmailAccount.MethodType alertMethodType) {
            MethodType methodType;
            Intrinsics.checkNotNullParameter((Object)((Object)alertMethodType), (String)"alertMethodType");
            switch (WhenMappings.$EnumSwitchMapping$1[alertMethodType.ordinal()]) {
                case 1: {
                    methodType = MethodType.NONE;
                    break;
                }
                case 2: {
                    methodType = MethodType.SSL;
                    break;
                }
                case 3: {
                    methodType = MethodType.START_TLS;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return methodType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[DestinationType.values().length];
                nArray[DestinationType.CHIME.ordinal()] = 1;
                nArray[DestinationType.SLACK.ordinal()] = 2;
                nArray[DestinationType.CUSTOM_WEBHOOK.ordinal()] = 3;
                nArray[DestinationType.EMAIL.ordinal()] = 4;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[EmailAccount.MethodType.values().length];
                nArray[EmailAccount.MethodType.NONE.ordinal()] = 1;
                nArray[EmailAccount.MethodType.SSL.ordinal()] = 2;
                nArray[EmailAccount.MethodType.TLS.ordinal()] = 3;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

