/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.model;

import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.reportsscheduler.model.RestTag;
import org.opensearch.reportsscheduler.util.HelpersKt;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 &*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001&B5\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u001f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0004\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010B\u0017\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0013J!\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u000bH&\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019\u00a8\u0006'"}, d2={"Lorg/opensearch/reportsscheduler/model/SearchResults;", "ItemClass", "Lorg/opensearch/core/xcontent/ToXContentObject;", "startIndex", "", "totalHits", "totalHitRelation", "Lorg/apache/lucene/search/TotalHits$Relation;", "objectList", "", "objectListFieldName", "", "(JJLorg/apache/lucene/search/TotalHits$Relation;Ljava/util/List;Ljava/lang/String;)V", "from", "response", "Lorg/opensearch/action/search/SearchResponse;", "(JLorg/opensearch/action/search/SearchResponse;Ljava/lang/String;)V", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "(Lorg/opensearch/core/xcontent/XContentParser;Ljava/lang/String;)V", "getObjectList", "()Ljava/util/List;", "getObjectListFieldName", "()Ljava/lang/String;", "getStartIndex", "()J", "getTotalHitRelation", "()Lorg/apache/lucene/search/TotalHits$Relation;", "getTotalHits", "parseItem", "useId", "(Lorg/opensearch/core/xcontent/XContentParser;Ljava/lang/String;)Lorg/opensearch/core/xcontent/ToXContentObject;", "parseItemList", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "Companion", "opensearch-reports-scheduler"})
public abstract class SearchResults<ItemClass extends ToXContentObject>
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long startIndex;
    private final long totalHits;
    @NotNull
    private final TotalHits.Relation totalHitRelation;
    @NotNull
    private final List<ItemClass> objectList;
    @NotNull
    private final String objectListFieldName;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(SearchResults.class);
    @NotNull
    private static final String START_INDEX_TAG = "startIndex";
    @NotNull
    private static final String TOTAL_HITS_TAG = "totalHits";
    @NotNull
    private static final String TOTAL_HIT_RELATION_TAG = "totalHitRelation";

    public final long getStartIndex() {
        return this.startIndex;
    }

    public final long getTotalHits() {
        return this.totalHits;
    }

    @NotNull
    public final TotalHits.Relation getTotalHitRelation() {
        return this.totalHitRelation;
    }

    @NotNull
    public final List<ItemClass> getObjectList() {
        return this.objectList;
    }

    @NotNull
    public final String getObjectListFieldName() {
        return this.objectListFieldName;
    }

    public SearchResults(long startIndex, long totalHits, @NotNull TotalHits.Relation totalHitRelation, @NotNull List<? extends ItemClass> objectList, @NotNull String objectListFieldName) {
        Intrinsics.checkNotNullParameter((Object)totalHitRelation, (String)TOTAL_HIT_RELATION_TAG);
        Intrinsics.checkNotNullParameter(objectList, (String)"objectList");
        Intrinsics.checkNotNullParameter((Object)objectListFieldName, (String)"objectListFieldName");
        this.startIndex = startIndex;
        this.totalHits = totalHits;
        this.totalHitRelation = totalHitRelation;
        this.objectList = objectList;
        this.objectListFieldName = objectListFieldName;
    }

    public SearchResults(long from, @NotNull SearchResponse response, @NotNull String objectListFieldName) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)objectListFieldName, (String)"objectListFieldName");
        List mutableList = new ArrayList();
        SearchHits searchHits = response.getHits();
        Intrinsics.checkNotNullExpressionValue((Object)searchHits, (String)"response.hits");
        Iterable $this$forEach$iv = (Iterable)searchHits;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchHit it = (SearchHit)element$iv;
            boolean bl = false;
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, it.getSourceAsString());
            parser.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
            mutableList.add(this.parseItem(parser, it.getId()));
        }
        TotalHits totalHits = response.getHits().getTotalHits();
        long totalHitsVal = 0L;
        TotalHits.Relation totalHitsRelation = null;
        if (totalHits == null) {
            totalHitsVal = mutableList.size();
            totalHitsRelation = TotalHits.Relation.EQUAL_TO;
        } else {
            totalHitsVal = totalHits.value;
            TotalHits.Relation relation = totalHits.relation;
            Intrinsics.checkNotNullExpressionValue((Object)relation, (String)"totalHits.relation");
            totalHitsRelation = relation;
        }
        this.startIndex = from;
        this.totalHits = totalHitsVal;
        this.totalHitRelation = totalHitsRelation;
        this.objectList = mutableList;
        this.objectListFieldName = objectListFieldName;
    }

    public SearchResults(@NotNull XContentParser parser, @NotNull String objectListFieldName) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)objectListFieldName, (String)"objectListFieldName");
        long startIndex = 0L;
        long totalHits = 0L;
        TotalHits.Relation totalHitRelation = TotalHits.Relation.EQUAL_TO;
        List<ItemClass> objectList = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
            String fieldName = parser.currentName();
            parser.nextToken();
            String string = fieldName;
            if (Intrinsics.areEqual((Object)string, (Object)START_INDEX_TAG)) {
                startIndex = parser.longValue();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)TOTAL_HITS_TAG)) {
                totalHits = parser.longValue();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)TOTAL_HIT_RELATION_TAG)) {
                String string2 = parser.text();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.text()");
                totalHitRelation = SearchResults.Companion.convertRelation(string2);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)objectListFieldName)) {
                objectList = this.parseItemList(parser);
                continue;
            }
            parser.skipChildren();
            SearchResults.Companion.getLog().info("reports:Skipping Unknown field " + fieldName);
        }
        if (objectList == null) {
            throw new IllegalArgumentException(objectListFieldName + " field absent");
        }
        if (totalHits == 0L) {
            totalHits = objectList.size();
        }
        this.startIndex = startIndex;
        this.totalHits = totalHits;
        this.totalHitRelation = totalHitRelation;
        this.objectList = objectList;
        this.objectListFieldName = objectListFieldName;
    }

    private final List<ItemClass> parseItemList(XContentParser parser) {
        List retList = new ArrayList();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            retList.add(SearchResults.parseItem$default(this, parser, null, 2, null));
        }
        return retList;
    }

    @NotNull
    public abstract ItemClass parseItem(@NotNull XContentParser var1, @Nullable String var2);

    public static /* synthetic */ ToXContentObject parseItem$default(SearchResults searchResults, XContentParser xContentParser, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseItem");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return searchResults.parseItem(xContentParser, string);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        ToXContent.Params params2 = params;
        if (params2 == null) {
            params2 = RestTag.INSTANCE.getREST_OUTPUT_PARAMS();
        }
        ToXContent.Params xContentParams = params2;
        XContentBuilder xContentBuilder = builder;
        Intrinsics.checkNotNull((Object)xContentBuilder);
        xContentBuilder.startObject().field(START_INDEX_TAG, this.startIndex).field(TOTAL_HITS_TAG, this.totalHits).field(TOTAL_HIT_RELATION_TAG, SearchResults.Companion.convertRelation(this.totalHitRelation)).startArray(this.objectListFieldName);
        Iterable $this$forEach$iv = this.objectList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ToXContentObject it = (ToXContentObject)element$iv;
            boolean bl = false;
            it.toXContent(builder, xContentParams);
        }
        XContentBuilder xContentBuilder2 = builder.endArray().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.endArray().endObject()");
        return xContentBuilder2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/reportsscheduler/model/SearchResults$Companion;", "", "()V", "START_INDEX_TAG", "", "TOTAL_HITS_TAG", "TOTAL_HIT_RELATION_TAG", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "convertRelation", "Lorg/apache/lucene/search/TotalHits$Relation;", "totalHitRelation", "opensearch-reports-scheduler"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        private final String convertRelation(TotalHits.Relation totalHitRelation) {
            return totalHitRelation == TotalHits.Relation.EQUAL_TO ? "eq" : "gte";
        }

        private final TotalHits.Relation convertRelation(String totalHitRelation) {
            return Intrinsics.areEqual((Object)totalHitRelation, (Object)"eq") ? TotalHits.Relation.EQUAL_TO : TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

