/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.multipage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.PrintConfiguration;
import net.sf.sdedit.diagram.AbstractPaintDevice;
import net.sf.sdedit.diagram.DiagramFactory;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.multipage.ExportDocument;
import net.sf.sdedit.multipage.MultipagePaintDevice;
import net.sf.sdedit.ui.components.ZoomPane;
import net.sf.sdedit.ui.impl.DiagramTab;
import net.sf.sdedit.util.OS;
import net.sf.sdedit.util.Utilities;
import net.sf.sdedit.util.WindowsRegistry;
import org.freehep.graphicsio.PageConstants;

public class MultipageExporter
extends JPanel {
    private static final long serialVersionUID = 6686854000552365972L;
    private static Class<? extends Graphics2D> ps;
    private static Class<? extends Graphics2D> pdf;
    private Configuration configuration;
    private Dimension size;
    private MultipagePaintDevice graphicDevice;
    private double scale;
    private Dimension previewSize;
    private PrintConfiguration properties;
    private DiagramTab tab;

    public static boolean isAvailable() {
        return pdf != null;
    }

    public MultipageExporter(PrintConfiguration properties, DiagramTab tab, Configuration configuration) {
        this.properties = properties;
        this.tab = tab;
        this.configuration = configuration;
        this.size = PageConstants.getSize(properties.getFormat(), properties.getOrientation());
        double wide = 315.0;
        if (properties.getOrientation().equals("Portrait")) {
            this.scale = wide / (double)this.size.height;
            this.previewSize = new Dimension(223, 315);
        } else {
            this.scale = wide / (double)this.size.width;
            this.previewSize = new Dimension(315, 223);
        }
    }

    public double getScale() {
        return this.graphicDevice.getScale();
    }

    public void init() throws DiagramError {
        this.graphicDevice = new MultipagePaintDevice(this.properties, this.size);
        AbstractPaintDevice pd = this.tab.createPaintDevice(this.graphicDevice);
        String cmd = this.properties.getCommand();
        if (cmd == null || Utilities.in(cmd, "", "AcroRd32.exe")) {
            if (OS.TYPE == OS.Type.WINDOWS) {
                int i;
                String value = WindowsRegistry.getValue("HKEY_CLASSES_ROOT/acrobat/shell/open/command", "(Standard)");
                if (value != null && value.length() > 0 && value.charAt(0) == '\"' && (i = (value = value.substring(1)).indexOf(34)) > 0) {
                    value = value.substring(0, i);
                    this.properties.setCommand(value);
                }
            } else {
                this.properties.setCommand("lpr");
            }
        }
        DiagramFactory factory = this.tab.createFactory(pd);
        factory.generateDiagram(this.configuration);
        int n = this.graphicDevice.getPanels().size();
        this.setLayout(new BoxLayout(this, 0));
        int i = 0;
        for (MultipagePaintDevice.MultipagePanel panel : this.graphicDevice.getPanels()) {
            ++i;
            JPanel wrap = new JPanel();
            wrap.setLayout(new BoxLayout(wrap, 1));
            wrap.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
            wrap.setAlignmentY(0.5f);
            ZoomPane zoomPane = new ZoomPane(false);
            zoomPane.setViewportView(panel);
            zoomPane.setScale(this.scale);
            zoomPane.setMinimumSize(this.previewSize);
            zoomPane.setMaximumSize(this.previewSize);
            zoomPane.setPreferredSize(this.previewSize);
            zoomPane.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            wrap.add(zoomPane);
            JLabel label = new JLabel(i + "/" + n);
            label.setAlignmentX(0.5f);
            wrap.add(label);
            this.add(wrap);
        }
    }

    public void exportTo(OutputStream stream, String type) throws IOException {
        Class<? extends Graphics2D> gc = type.toLowerCase().equals("pdf") ? pdf : ps;
        ExportDocument export = new ExportDocument(gc, this.graphicDevice, stream, this.properties.getFormat(), this.properties.getOrientation());
        export.export();
    }

    static {
        try {
            ps = Class.forName("org.freehep.graphicsio.ps.PSGraphics2D");
            pdf = Class.forName("org.freehep.graphicsio.pdf.PDFGraphics2D");
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

