/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Primitive;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class PKeyRSA
extends org.jruby.ext.openssl.PKey {
    private static final long serialVersionUID = -2540383779256333197L;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public PKeyRSA allocate(Ruby runtime, RubyClass klass) {
            return new PKeyRSA(runtime, klass);
        }
    };
    private volatile RSAPublicKey publicKey;
    private volatile transient RSAPrivateCrtKey privateKey;
    private volatile transient BigInteger rsa_e;
    private volatile transient BigInteger rsa_n;
    private volatile transient BigInteger rsa_d;
    private volatile transient BigInteger rsa_p;
    private volatile transient BigInteger rsa_q;
    private volatile transient BigInteger rsa_dmp1;
    private volatile transient BigInteger rsa_dmq1;
    private volatile transient BigInteger rsa_iqmp;

    static void createPKeyRSA(Ruby runtime, RubyModule PKey2, RubyClass PKeyPKey, RubyClass PKeyError) {
        RubyClass RSA = PKey2.defineClassUnder("RSA", PKeyPKey, ALLOCATOR);
        PKey2.defineClassUnder("RSAError", PKeyError, PKeyError.getAllocator());
        RSA.defineAnnotatedMethods(PKeyRSA.class);
        RSA.setConstant("PKCS1_PADDING", (IRubyObject)runtime.newFixnum(1));
        RSA.setConstant("SSLV23_PADDING", (IRubyObject)runtime.newFixnum(2));
        RSA.setConstant("NO_PADDING", (IRubyObject)runtime.newFixnum(3));
        RSA.setConstant("PKCS1_OAEP_PADDING", (IRubyObject)runtime.newFixnum(4));
    }

    static RubyClass _RSA(Ruby runtime) {
        return PKeyRSA._PKey(runtime).getClass("RSA");
    }

    public static RaiseException newRSAError(Ruby runtime, String message) {
        return Utils.newError(runtime, PKeyRSA._PKey(runtime).getClass("RSAError"), message);
    }

    static RaiseException newRSAError(Ruby runtime, Throwable cause) {
        return Utils.newError(runtime, PKeyRSA._PKey(runtime).getClass("RSAError"), cause.getMessage(), cause);
    }

    public PKeyRSA(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public PKeyRSA(Ruby runtime, RubyClass type, RSAPrivateCrtKey privKey, RSAPublicKey pubKey) {
        super(runtime, type);
        this.privateKey = privKey;
        this.publicKey = pubKey;
    }

    PKeyRSA(Ruby runtime, RSAPublicKey pubKey) {
        this(runtime, PKeyRSA._RSA(runtime), null, pubKey);
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        PKeyRSA that = (PKeyRSA)original;
        this.publicKey = that.publicKey;
        this.privateKey = that.privateKey;
        this.rsa_e = that.rsa_e;
        this.rsa_n = that.rsa_n;
        this.rsa_d = that.rsa_d;
        this.rsa_p = that.rsa_p;
        this.rsa_q = that.rsa_q;
        this.rsa_dmp1 = that.rsa_dmp1;
        this.rsa_dmq1 = that.rsa_dmq1;
        this.rsa_iqmp = that.rsa_iqmp;
        return this;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @JRubyMethod(name={"generate"}, meta=true, rest=true)
    public static IRubyObject generate(IRubyObject self, IRubyObject[] args) {
        Ruby runtime = self.getRuntime();
        BigInteger exp2 = RSAKeyGenParameterSpec.F4;
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)2) == 2) {
            exp2 = args[1] instanceof RubyFixnum ? BigInteger.valueOf(RubyNumeric.num2long((IRubyObject)args[1])) : ((RubyBignum)args[1]).getValue();
        }
        int keySize = RubyNumeric.fix2int((IRubyObject)args[0]);
        return PKeyRSA.rsaGenerate(runtime, new PKeyRSA(runtime, (RubyClass)self), keySize, exp2);
    }

    private static PKeyRSA rsaGenerate(Ruby runtime, PKeyRSA rsa, int keySize, BigInteger exp2) throws RaiseException {
        try {
            KeyPairGenerator gen = SecurityHelper.getKeyPairGenerator("RSA");
            if ("IBMJCEFIPS".equals(gen.getProvider().getName())) {
                gen.initialize(keySize);
            } else {
                gen.initialize(new RSAKeyGenParameterSpec(keySize, exp2), PKeyRSA.getSecureRandom(runtime));
            }
            KeyPair pair = gen.generateKeyPair();
            rsa.privateKey = (RSAPrivateCrtKey)pair.getPrivate();
            rsa.publicKey = (RSAPublicKey)pair.getPublic();
        }
        catch (NoSuchAlgorithmException e) {
            throw PKeyRSA.newRSAError(runtime, e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw PKeyRSA.newRSAError(runtime, e.getMessage());
        }
        catch (RuntimeException e) {
            throw PKeyRSA.newRSAError(rsa.getRuntime(), e);
        }
        return rsa;
    }

    static PKeyRSA newInstance(Ruby runtime, PublicKey publicKey) {
        return new PKeyRSA(runtime, (RSAPublicKey)publicKey);
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args, Block block) {
        KeyFactory rsaFactory;
        IRubyObject arg1;
        Ruby runtime = context2.runtime;
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2) == 0) {
            this.privateKey = null;
            this.publicKey = null;
            return this;
        }
        IRubyObject arg = args[0];
        IRubyObject iRubyObject = arg1 = args.length > 1 ? args[1] : null;
        if (arg instanceof RubyFixnum) {
            int keySize = RubyNumeric.fix2int((RubyFixnum)((RubyFixnum)arg));
            BigInteger exp2 = RSAKeyGenParameterSpec.F4;
            if (arg1 != null && !arg1.isNil()) {
                exp2 = BigInteger.valueOf(RubyNumeric.num2long((IRubyObject)arg1));
            }
            return PKeyRSA.rsaGenerate(runtime, this, keySize, exp2);
        }
        char[] passwd = PKeyRSA.password(context2, arg1, block);
        RubyString str = PKeyRSA.readInitArg(context2, arg);
        String strJava = str.toString();
        Object key = null;
        try {
            rsaFactory = SecurityHelper.getKeyFactory("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime.newRuntimeError("unsupported key algorithm (RSA)");
        }
        catch (RuntimeException e) {
            throw runtime.newRuntimeError("unsupported key algorithm (RSA) " + e);
        }
        boolean noClassDef = false;
        if (key == null && !noClassDef) {
            try {
                key = PKeyRSA.readPrivateKey(strJava, passwd);
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (PEMInputOutput.PasswordRequiredException retry) {
                if (PKeyRSA.ttySTDIN(context2)) {
                    try {
                        key = PKeyRSA.readPrivateKey(strJava, PKeyRSA.passwordPrompt(context2));
                    }
                    catch (Exception e) {
                        OpenSSL.debugStackTrace(runtime, e);
                    }
                }
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readRSAPublicKey(new StringReader(strJava), passwd);
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readRSAPubKey(new StringReader(strJava));
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PKey.readRSAPrivateKey(rsaFactory, str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (InvalidKeySpecException e) {
                OpenSSL.debug(runtime, "PKeyRSA could not read private key", e);
            }
            catch (IOException e) {
                OpenSSL.debugStackTrace(runtime, "PKeyRSA could not read private key", e);
            }
            catch (RuntimeException e) {
                if (PKeyRSA.isKeyGenerationFailure(e)) {
                    OpenSSL.debug(runtime, "PKeyRSA could not read private key", e);
                }
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PKey.readRSAPublicKey(rsaFactory, str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (InvalidKeySpecException e) {
                OpenSSL.debug(runtime, "PKeyRSA could not read public key", e);
            }
            catch (IOException e) {
                OpenSSL.debugStackTrace(runtime, "PKeyRSA could not read public key", e);
            }
            catch (RuntimeException e) {
                if (PKeyRSA.isKeyGenerationFailure(e)) {
                    OpenSSL.debug(runtime, "PKeyRSA could not read public key", e);
                }
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null) {
            key = this.tryPKCS8EncodedKey(runtime, rsaFactory, str.getBytes());
        }
        if (key == null) {
            key = this.tryX509EncodedKey(runtime, rsaFactory, str.getBytes());
        }
        if (key == null) {
            throw PKeyRSA.newRSAError(runtime, "Neither PUB key nor PRIV key:");
        }
        if (key instanceof KeyPair) {
            PublicKey publicKey = ((KeyPair)key).getPublic();
            PrivateKey privateKey = ((KeyPair)key).getPrivate();
            if (!(privateKey instanceof RSAPrivateCrtKey)) {
                if (privateKey == null) {
                    throw PKeyRSA.newRSAError(runtime, "Neither PUB key nor PRIV key: (private key is null)");
                }
                throw PKeyRSA.newRSAError(runtime, "Neither PUB key nor PRIV key: (invalid key type " + privateKey.getClass().getName() + ")");
            }
            this.privateKey = (RSAPrivateCrtKey)privateKey;
            this.publicKey = (RSAPublicKey)publicKey;
        } else if (key instanceof RSAPrivateCrtKey) {
            this.privateKey = (RSAPrivateCrtKey)key;
            try {
                this.publicKey = (RSAPublicKey)rsaFactory.generatePublic(new RSAPublicKeySpec(this.privateKey.getModulus(), this.privateKey.getPublicExponent()));
            }
            catch (GeneralSecurityException e) {
                throw PKeyRSA.newRSAError(runtime, e.getMessage());
            }
            catch (RuntimeException e) {
                OpenSSL.debugStackTrace(runtime, e);
                throw PKeyRSA.newRSAError(runtime, e.toString());
            }
        } else if (key instanceof RSAPublicKey) {
            this.publicKey = (RSAPublicKey)key;
            this.privateKey = null;
        } else {
            throw PKeyRSA.newRSAError(runtime, "Neither PUB key nor PRIV key: " + key.getClass().getName());
        }
        return this;
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.publicKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    public boolean isPrivateKey() {
        return this.privateKey != null;
    }

    @JRubyMethod(name={"private?"})
    public RubyBoolean private_p() {
        return this.getRuntime().newBoolean(this.isPrivateKey());
    }

    @Override
    @JRubyMethod(name={"to_der"})
    public RubyString to_der() {
        byte[] bytes;
        try {
            bytes = PKey.toDerRSAKey(this.publicKey, this.privateKey);
        }
        catch (NoClassDefFoundError e) {
            throw PKeyRSA.newRSAError(this.getRuntime(), OpenSSL.bcExceptionMessage(e));
        }
        catch (IOException e) {
            throw PKeyRSA.newRSAError(this.getRuntime(), e.getMessage());
        }
        return StringHelper.newString(this.getRuntime(), bytes);
    }

    @Override
    public ASN1Primitive toASN1PublicInfo() {
        return PKey.toASN1Primitive(this.publicKey);
    }

    @JRubyMethod
    public PKeyRSA public_key() {
        return new PKeyRSA(this.getRuntime(), this.publicKey);
    }

    @JRubyMethod
    public IRubyObject params(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        RubyHash hash2 = RubyHash.newHash((Ruby)runtime);
        if (this.privateKey != null) {
            hash2.op_aset(context2, (IRubyObject)runtime.newString("iqmp"), (IRubyObject)BN.newBN(runtime, this.privateKey.getCrtCoefficient()));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("n"), (IRubyObject)BN.newBN(runtime, this.privateKey.getModulus()));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("d"), (IRubyObject)BN.newBN(runtime, this.privateKey.getPrivateExponent()));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("p"), (IRubyObject)BN.newBN(runtime, this.privateKey.getPrimeP()));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("e"), (IRubyObject)BN.newBN(runtime, this.privateKey.getPublicExponent()));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("q"), (IRubyObject)BN.newBN(runtime, this.privateKey.getPrimeQ()));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("dmq1"), (IRubyObject)BN.newBN(runtime, this.privateKey.getPrimeExponentQ()));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("dmp1"), (IRubyObject)BN.newBN(runtime, this.privateKey.getPrimeExponentP()));
        } else {
            hash2.op_aset(context2, (IRubyObject)runtime.newString("iqmp"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("n"), (IRubyObject)BN.newBN(runtime, this.publicKey.getModulus()));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("d"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("p"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("e"), (IRubyObject)BN.newBN(runtime, this.publicKey.getPublicExponent()));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("q"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("dmq1"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
            hash2.op_aset(context2, (IRubyObject)runtime.newString("dmp1"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
        }
        return hash2;
    }

    @JRubyMethod
    public RubyString to_text() {
        StringBuilder result = new StringBuilder();
        if (this.privateKey != null) {
            int len = this.privateKey.getModulus().bitLength();
            result.append("Private-Key: (").append(len).append(" bit)").append('\n');
            result.append("modulus:");
            PKeyRSA.addSplittedAndFormatted(result, this.privateKey.getModulus());
            result.append("publicExponent: ").append(this.privateKey.getPublicExponent()).append(" (0x").append(this.privateKey.getPublicExponent().toString(16)).append(")\n");
            result.append("privateExponent:");
            PKeyRSA.addSplittedAndFormatted(result, this.privateKey.getPrivateExponent());
            result.append("prime1:");
            PKeyRSA.addSplittedAndFormatted(result, this.privateKey.getPrimeP());
            result.append("prime2:");
            PKeyRSA.addSplittedAndFormatted(result, this.privateKey.getPrimeQ());
            result.append("exponent1:");
            PKeyRSA.addSplittedAndFormatted(result, this.privateKey.getPrimeExponentP());
            result.append("exponent2:");
            PKeyRSA.addSplittedAndFormatted(result, this.privateKey.getPrimeExponentQ());
            result.append("coefficient:");
            PKeyRSA.addSplittedAndFormatted(result, this.privateKey.getCrtCoefficient());
        } else {
            int len = this.publicKey.getModulus().bitLength();
            result.append("Modulus (").append(len).append(" bit):");
            PKeyRSA.addSplittedAndFormatted(result, this.publicKey.getModulus());
            result.append("Exponent: ").append(this.publicKey.getPublicExponent()).append(" (0x").append(this.publicKey.getPublicExponent().toString(16)).append(")\n");
        }
        return RubyString.newString((Ruby)this.getRuntime(), (CharSequence)result);
    }

    @Override
    @JRubyMethod(name={"to_pem", "to_s"}, alias={"export"}, rest=true)
    public RubyString to_pem(ThreadContext context2, IRubyObject[] args) {
        Arity.checkArgumentCount((Ruby)context2.runtime, (IRubyObject[])args, (int)0, (int)2);
        CipherSpec spec = null;
        char[] passwd = null;
        if (args.length > 0) {
            spec = PKeyRSA.cipherSpec(args[0]);
            if (args.length > 1) {
                passwd = PKeyRSA.password(context2, args[1], null);
            }
        }
        try {
            StringWriter writer = new StringWriter();
            if (this.privateKey != null) {
                PEMInputOutput.writeRSAPrivateKey(writer, this.privateKey, spec, passwd);
            } else {
                PEMInputOutput.writeRSAPublicKey(writer, this.publicKey);
            }
            return RubyString.newString((Ruby)context2.runtime, (CharSequence)writer.getBuffer());
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyRSA.newRSAError(context2.runtime, OpenSSL.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyRSA.newRSAError(context2.runtime, ioe.getMessage());
        }
    }

    private String getPadding(int padding) {
        if (padding < 1 || padding > 4) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "");
        }
        String p = "/ECB/PKCS1Padding";
        if (padding == 3) {
            p = "/ECB/NoPadding";
        } else if (padding == 4) {
            p = "/ECB/OAEPWithSHA1AndMGF1Padding";
        } else if (padding == 2) {
            p = "/ECB/ISO9796-1Padding";
        }
        return p;
    }

    @JRubyMethod(rest=true)
    public IRubyObject private_encrypt(ThreadContext context2, IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)context2.runtime, (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        if (this.privateKey == null) {
            throw PKeyRSA.newRSAError(context2.runtime, "incomplete RSA");
        }
        return this.doCipherRSA(context2.runtime, args[0], padding, 1, this.privateKey);
    }

    @JRubyMethod(rest=true)
    public IRubyObject private_decrypt(ThreadContext context2, IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)context2.runtime, (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        if (this.privateKey == null) {
            throw PKeyRSA.newRSAError(context2.runtime, "incomplete RSA");
        }
        return this.doCipherRSA(context2.runtime, args[0], padding, 2, this.privateKey);
    }

    @JRubyMethod(rest=true)
    public IRubyObject public_encrypt(ThreadContext context2, IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)context2.runtime, (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        if (this.publicKey == null) {
            throw PKeyRSA.newRSAError(context2.runtime, "incomplete RSA");
        }
        return this.doCipherRSA(context2.runtime, args[0], padding, 1, this.publicKey);
    }

    @JRubyMethod(rest=true)
    public IRubyObject public_decrypt(ThreadContext context2, IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)context2.runtime, (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        if (this.publicKey == null) {
            throw PKeyRSA.newRSAError(context2.runtime, "incomplete RSA");
        }
        return this.doCipherRSA(context2.runtime, args[0], padding, 2, this.publicKey);
    }

    private RubyString doCipherRSA(Ruby runtime, IRubyObject content, int padding, int initMode, Key initKey) {
        String cipherPadding = this.getPadding(padding);
        RubyString buffer = content.convertToString();
        try {
            Cipher engine = SecurityHelper.getCipher("RSA" + cipherPadding);
            engine.init(initMode, initKey);
            byte[] output = engine.doFinal(buffer.getBytes());
            return StringHelper.newString(runtime, output);
        }
        catch (GeneralSecurityException gse) {
            throw PKeyRSA.newRSAError(runtime, gse.getMessage());
        }
    }

    @JRubyMethod(name={"d="})
    public synchronized IRubyObject set_d(ThreadContext context2, IRubyObject value2) {
        if (this.privateKey != null) {
            throw PKeyRSA.newRSAError(context2.runtime, "illegal modification");
        }
        this.rsa_d = BN.getBigInteger(value2);
        this.generatePrivateKeyIfParams(context2);
        return value2;
    }

    @JRubyMethod(name={"p="})
    public synchronized IRubyObject set_p(ThreadContext context2, IRubyObject value2) {
        if (this.privateKey != null) {
            throw PKeyRSA.newRSAError(context2.runtime, "illegal modification");
        }
        this.rsa_p = BN.getBigInteger(value2);
        this.generatePrivateKeyIfParams(context2);
        return value2;
    }

    @JRubyMethod(name={"q="})
    public synchronized IRubyObject set_q(ThreadContext context2, IRubyObject value2) {
        if (this.privateKey != null) {
            throw PKeyRSA.newRSAError(context2.runtime, "illegal modification");
        }
        this.rsa_q = BN.getBigInteger(value2);
        this.generatePrivateKeyIfParams(context2);
        return value2;
    }

    @JRubyMethod(name={"dmp1="})
    public synchronized IRubyObject set_dmp1(ThreadContext context2, IRubyObject value2) {
        if (this.privateKey != null) {
            throw PKeyRSA.newRSAError(context2.runtime, "illegal modification");
        }
        this.rsa_dmp1 = BN.asBigInteger(value2);
        this.generatePrivateKeyIfParams(context2);
        return value2;
    }

    @JRubyMethod(name={"dmq1="})
    public synchronized IRubyObject set_dmq1(ThreadContext context2, IRubyObject value2) {
        if (this.privateKey != null) {
            throw PKeyRSA.newRSAError(context2.runtime, "illegal modification");
        }
        this.rsa_dmq1 = BN.asBigInteger(value2);
        this.generatePrivateKeyIfParams(context2);
        return value2;
    }

    @JRubyMethod(name={"iqmp="})
    public synchronized IRubyObject set_iqmp(ThreadContext context2, IRubyObject value2) {
        if (this.privateKey != null) {
            throw PKeyRSA.newRSAError(context2.runtime, "illegal modification");
        }
        this.rsa_iqmp = BN.asBigInteger(value2);
        this.generatePrivateKeyIfParams(context2);
        return value2;
    }

    @JRubyMethod(name={"iqmp"})
    public synchronized IRubyObject get_iqmp() {
        BigInteger iqmp = this.privateKey != null ? this.privateKey.getCrtCoefficient() : this.rsa_iqmp;
        if (iqmp != null) {
            return BN.newBN(this.getRuntime(), iqmp);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"dmp1"})
    public synchronized IRubyObject get_dmp1() {
        BigInteger dmp1 = this.privateKey != null ? this.privateKey.getPrimeExponentP() : this.rsa_dmp1;
        if (dmp1 != null) {
            return BN.newBN(this.getRuntime(), dmp1);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"dmq1"})
    public synchronized IRubyObject get_dmq1() {
        BigInteger dmq1 = this.privateKey != null ? this.privateKey.getPrimeExponentQ() : this.rsa_dmq1;
        if (dmq1 != null) {
            return BN.newBN(this.getRuntime(), dmq1);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"d"})
    public synchronized IRubyObject get_d() {
        BigInteger d = this.privateKey != null ? this.privateKey.getPrivateExponent() : this.rsa_d;
        if (d != null) {
            return BN.newBN(this.getRuntime(), d);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"p"})
    public synchronized IRubyObject get_p() {
        BigInteger p = this.privateKey != null ? this.privateKey.getPrimeP() : this.rsa_p;
        if (p != null) {
            return BN.newBN(this.getRuntime(), p);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"q"})
    public synchronized IRubyObject get_q() {
        BigInteger q = this.privateKey != null ? this.privateKey.getPrimeQ() : this.rsa_q;
        if (q != null) {
            return BN.newBN(this.getRuntime(), q);
        }
        return this.getRuntime().getNil();
    }

    private BigInteger getPublicExponent() {
        if (this.publicKey != null) {
            return this.publicKey.getPublicExponent();
        }
        if (this.privateKey != null) {
            return this.privateKey.getPublicExponent();
        }
        return this.rsa_e;
    }

    @JRubyMethod(name={"e"})
    public synchronized IRubyObject get_e() {
        BigInteger e = this.getPublicExponent();
        if (e != null) {
            return BN.newBN(this.getRuntime(), e);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"e="})
    public synchronized IRubyObject set_e(ThreadContext context2, IRubyObject value2) {
        this.rsa_e = BN.getBigInteger(value2);
        if (this.privateKey == null) {
            this.generatePrivateKeyIfParams(context2);
        }
        if (this.publicKey == null) {
            this.generatePublicKeyIfParams(context2);
        }
        return value2;
    }

    private BigInteger getModulus() {
        if (this.publicKey != null) {
            return this.publicKey.getModulus();
        }
        if (this.privateKey != null) {
            return this.privateKey.getModulus();
        }
        return this.rsa_n;
    }

    @JRubyMethod(name={"n"})
    public synchronized IRubyObject get_n() {
        BigInteger n = this.getModulus();
        if (n != null) {
            return BN.newBN(this.getRuntime(), n);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"n="})
    public synchronized IRubyObject set_n(ThreadContext context2, IRubyObject value2) {
        this.rsa_n = BN.getBigInteger(value2);
        if (this.privateKey == null) {
            this.generatePrivateKeyIfParams(context2);
        }
        if (this.publicKey == null) {
            this.generatePublicKeyIfParams(context2);
        }
        return value2;
    }

    private void generatePublicKeyIfParams(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        if (this.publicKey != null) {
            throw PKeyRSA.newRSAError(runtime, "illegal modification");
        }
        BigInteger _rsa_n = this.getModulus();
        BigInteger _rsa_e = this.getPublicExponent();
        if (_rsa_n != null && _rsa_e != null) {
            KeyFactory rsaFactory;
            try {
                rsaFactory = SecurityHelper.getKeyFactory("RSA");
            }
            catch (Exception ex) {
                throw runtime.newLoadError("unsupported key algorithm (RSA)");
            }
            try {
                this.publicKey = (RSAPublicKey)rsaFactory.generatePublic(new RSAPublicKeySpec(_rsa_n, _rsa_e));
            }
            catch (InvalidKeySpecException ex) {
                throw PKeyRSA.newRSAError(runtime, "invalid parameters");
            }
            this.rsa_e = null;
            this.rsa_n = null;
        }
    }

    private void generatePrivateKeyIfParams(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        if (this.privateKey != null) {
            throw PKeyRSA.newRSAError(runtime, "illegal modification");
        }
        BigInteger _rsa_n = this.getModulus();
        BigInteger _rsa_e = this.getPublicExponent();
        if (_rsa_n != null && _rsa_e != null && this.rsa_p != null && this.rsa_q != null && this.rsa_d != null && this.rsa_dmp1 != null && this.rsa_dmq1 != null && this.rsa_iqmp != null) {
            KeyFactory rsaFactory;
            try {
                rsaFactory = SecurityHelper.getKeyFactory("RSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw runtime.newLoadError("unsupported key algorithm (RSA)");
            }
            try {
                this.privateKey = (RSAPrivateCrtKey)rsaFactory.generatePrivate(new RSAPrivateCrtKeySpec(_rsa_n, _rsa_e, this.rsa_d, this.rsa_p, this.rsa_q, this.rsa_dmp1, this.rsa_dmq1, this.rsa_iqmp));
            }
            catch (InvalidKeySpecException e) {
                throw PKeyRSA.newRSAError(runtime, "invalid parameters");
            }
            this.rsa_n = null;
            this.rsa_e = null;
            this.rsa_d = null;
            this.rsa_p = null;
            this.rsa_q = null;
            this.rsa_dmp1 = null;
            this.rsa_dmq1 = null;
            this.rsa_iqmp = null;
        }
    }
}

