/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.ad.constant.CommonName;
import org.opensearch.ad.model.ModelProfile;
import org.opensearch.ad.util.Bwc;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class ProfileNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private Map<String, Long> modelSize;
    private int shingleSize;
    private long activeEntities;
    private long totalUpdates;
    private List<ModelProfile> modelProfiles;
    private long modelCount;

    public ProfileNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.modelSize = in.readMap(StreamInput::readString, StreamInput::readLong);
        }
        this.shingleSize = in.readInt();
        this.activeEntities = in.readVLong();
        this.totalUpdates = in.readVLong();
        if (Bwc.supportMultiCategoryFields(in.getVersion()) && in.readBoolean()) {
            this.modelProfiles = in.readList(ModelProfile::new);
            this.modelCount = in.readVLong();
        }
    }

    public ProfileNodeResponse(DiscoveryNode node, Map<String, Long> modelSize, int shingleSize, long activeEntity, long totalUpdates, List<ModelProfile> modelProfiles, long modelCount) {
        super(node);
        this.modelSize = modelSize;
        this.shingleSize = shingleSize;
        this.activeEntities = activeEntity;
        this.totalUpdates = totalUpdates;
        this.modelProfiles = modelProfiles;
        this.modelCount = modelCount;
    }

    public static ProfileNodeResponse readProfiles(StreamInput in) throws IOException {
        return new ProfileNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.modelSize != null) {
            out.writeBoolean(true);
            out.writeMap(this.modelSize, StreamOutput::writeString, StreamOutput::writeLong);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.shingleSize);
        out.writeVLong(this.activeEntities);
        out.writeVLong(this.totalUpdates);
        if (Bwc.supportMultiCategoryFields(out.getVersion())) {
            if (this.modelProfiles != null) {
                out.writeBoolean(true);
                out.writeList(this.modelProfiles);
                out.writeVLong(this.modelCount);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("model_size_in_bytes");
        for (Map.Entry<String, Long> entry : this.modelSize.entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
        builder.field("shingle_size", this.shingleSize);
        builder.field("active_entities", this.activeEntities);
        builder.field("total_updates", this.totalUpdates);
        builder.field(CommonName.MODEL_COUNT, this.modelCount);
        builder.startArray("models");
        for (ModelProfile modelProfile : this.modelProfiles) {
            builder.startObject();
            modelProfile.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public Map<String, Long> getModelSize() {
        return this.modelSize;
    }

    public int getShingleSize() {
        return this.shingleSize;
    }

    public long getActiveEntities() {
        return this.activeEntities;
    }

    public long getTotalUpdates() {
        return this.totalUpdates;
    }

    public List<ModelProfile> getModelProfiles() {
        return this.modelProfiles;
    }

    public long getModelCount() {
        return this.modelCount;
    }
}

