/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.cmd.ShuffleAndCropCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.function.compress.WaypointComparer;

public class DedupeWaypointsFunction
extends GenericFunction {
    public DedupeWaypointsFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.dedupewaypoints";
    }

    @Override
    public void begin() {
        Object object;
        Track track = this._app.getTrackInfo().getTrack();
        HashMap<String, List<Integer>> hashMap = new HashMap<String, List<Integer>>();
        int n = 0;
        while (n < track.getNumPoints()) {
            object = track.getPoint(n);
            if (((DataPoint)object).isWaypoint()) {
                String string = DedupeWaypointsFunction.getWaypointKey((DataPoint)object);
                hashMap.put(string, DedupeWaypointsFunction.reduceWaypoints((List)hashMap.get(string), track, n));
            }
            ++n;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        object = new ArrayList();
        int n2 = 0;
        while (n2 < track.getNumPoints()) {
            DataPoint dataPoint = track.getPoint(n2);
            if (!dataPoint.isWaypoint()) {
                arrayList.add(n2);
            } else {
                String string = DedupeWaypointsFunction.getWaypointKey(dataPoint);
                List list = (List)hashMap.get(string);
                if (list.contains(n2)) {
                    arrayList.add(n2);
                } else {
                    ((ArrayList)object).add(n2);
                }
            }
            ++n2;
        }
        if (((ArrayList)object).isEmpty()) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.dedupewaypoints.nonefound");
        } else {
            this._app.execute(new ShuffleAndCropCmd(arrayList, (List<Integer>)object, null));
        }
    }

    static List<Integer> reduceWaypoints(List<Integer> list, Track track, int n) {
        ArrayList<WaypointComparer.CompareResult> arrayList;
        if (list == null || list.isEmpty()) {
            return List.of(Integer.valueOf(n));
        }
        DataPoint dataPoint = track.getPoint(n);
        if (DedupeWaypointsFunction.shouldIgnorePoint(dataPoint, list, track, arrayList = new ArrayList<WaypointComparer.CompareResult>())) {
            return list;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < list.size()) {
            WaypointComparer.CompareResult compareResult = arrayList.get(n2);
            if (compareResult != WaypointComparer.CompareResult.SECOND_BETTER) {
                arrayList2.add(list.get(n2));
            }
            ++n2;
        }
        arrayList2.add(n);
        return arrayList2;
    }

    static boolean shouldIgnorePoint(DataPoint dataPoint, List<Integer> list, Track track, ArrayList<WaypointComparer.CompareResult> arrayList) {
        arrayList.clear();
        for (int n : list) {
            WaypointComparer.CompareResult compareResult = WaypointComparer.compare(track.getPoint(n), dataPoint);
            if (compareResult == WaypointComparer.CompareResult.FIRST_BETTER || compareResult == WaypointComparer.CompareResult.IDENTICAL) {
                return true;
            }
            arrayList.add(compareResult);
        }
        return false;
    }

    private static String getWaypointKey(DataPoint dataPoint) {
        return String.valueOf(dataPoint.getFieldValue(Field.LATITUDE)) + "*" + dataPoint.getFieldValue(Field.LONGITUDE) + "*" + dataPoint.getWaypointName();
    }
}

