/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.rest;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.knn.plugin.transport.KNNStatsAction;
import org.opensearch.knn.plugin.transport.KNNStatsRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;

public class RestKNNStatsHandler
extends BaseRestHandler {
    private static final String NAME = "knn_stats_action";

    public String getName() {
        return NAME;
    }

    private List<String> getStatsPath() {
        ArrayList<String> statsPath = new ArrayList<String>();
        statsPath.add("/{nodeId}/stats/");
        statsPath.add("/{nodeId}/stats/{stat}");
        statsPath.add("/stats/");
        statsPath.add("/stats/{stat}");
        return statsPath;
    }

    private Map<String, String> getUrlPathByLegacyUrlPathMap() {
        return this.getStatsPath().stream().collect(Collectors.toMap(path -> "/_opendistro/_knn" + path, path -> "/_plugins/_knn" + path));
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return this.getUrlPathByLegacyUrlPathMap().entrySet().stream().map(e -> new RestHandler.ReplacedRoute(RestRequest.Method.GET, (String)e.getValue(), RestRequest.Method.GET, (String)e.getKey())).collect(Collectors.toList());
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        KNNStatsRequest knnStatsRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)KNNStatsAction.INSTANCE, (ActionRequest)knnStatsRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    private KNNStatsRequest getRequest(RestRequest request) {
        String[] nodeIdsArr = null;
        String nodesIdsStr = request.param("nodeId");
        if (StringUtils.isNotEmpty((String)nodesIdsStr)) {
            nodeIdsArr = nodesIdsStr.split(",");
        }
        KNNStatsRequest knnStatsRequest = new KNNStatsRequest(nodeIdsArr);
        knnStatsRequest.timeout(request.param("timeout"));
        HashSet<String> statsSet = null;
        String statsStr = request.param("stat");
        if (StringUtils.isNotEmpty((String)statsStr)) {
            statsSet = new HashSet<String>(Arrays.asList(statsStr.split(",")));
        }
        if (statsSet == null) {
            knnStatsRequest.all();
        } else if (statsSet.size() == 1 && statsSet.contains("_all")) {
            knnStatsRequest.all();
        } else {
            if (statsSet.contains("_all")) {
                throw new IllegalArgumentException("Request " + request.path() + " contains _all and individual stats");
            }
            TreeSet<String> invalidStats = new TreeSet<String>();
            for (String stat : statsSet) {
                if (knnStatsRequest.addStat(stat)) continue;
                invalidStats.add(stat);
            }
            if (!invalidStats.isEmpty()) {
                throw new IllegalArgumentException(this.unrecognized(request, invalidStats, knnStatsRequest.getStatsToBeRetrieved(), "stat"));
            }
        }
        return knnStatsRequest;
    }

    @Generated
    public RestKNNStatsHandler() {
    }
}

