/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ReadListener;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.security.SecurityUtil;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.Request;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.res.StringManager;

public class InputBuffer
extends Reader
implements ByteChunk.ByteInputChannel,
ApplicationBufferHandler {
    protected static final StringManager sm = StringManager.getManager(InputBuffer.class);
    private static final Log log = LogFactory.getLog(InputBuffer.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public final int INITIAL_STATE = 0;
    public final int CHAR_STATE = 1;
    public final int BYTE_STATE = 2;
    private static final ConcurrentMap<Charset, SynchronizedStack<B2CConverter>> encoders = new ConcurrentHashMap<Charset, SynchronizedStack<B2CConverter>>();
    private ByteBuffer bb;
    private CharBuffer cb;
    private int state = 0;
    private boolean closed = false;
    private String enc;
    protected B2CConverter conv;
    private Request coyoteRequest;
    private int markPos = -1;
    private int readLimit;
    private final int size;

    public InputBuffer() {
        this(8192);
    }

    public InputBuffer(int n) {
        this.size = n;
        this.bb = ByteBuffer.allocate(n);
        this.clear(this.bb);
        this.cb = CharBuffer.allocate(n);
        this.clear(this.cb);
        this.readLimit = n;
    }

    public void setRequest(Request request) {
        this.coyoteRequest = request;
    }

    public void recycle() {
        this.state = 0;
        if (this.cb.capacity() > this.size) {
            this.cb = CharBuffer.allocate(this.size);
            this.clear(this.cb);
        } else {
            this.clear(this.cb);
        }
        this.readLimit = this.size;
        this.markPos = -1;
        this.clear(this.bb);
        this.closed = false;
        if (this.conv != null) {
            this.conv.recycle();
            ((SynchronizedStack)encoders.get(this.conv.getCharset())).push((Object)this.conv);
            this.conv = null;
        }
        this.enc = null;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public int available() {
        int n = this.availableInThisBuffer();
        if (n == 0) {
            this.coyoteRequest.action(ActionCode.AVAILABLE, (Object)(this.coyoteRequest.getReadListener() != null ? 1 : 0));
            n = this.coyoteRequest.getAvailable() > 0 ? 1 : 0;
        }
        return n;
    }

    private int availableInThisBuffer() {
        int n = 0;
        if (this.state == 2) {
            n = this.bb.remaining();
        } else if (this.state == 1) {
            n = this.cb.remaining();
        }
        return n;
    }

    public void setReadListener(ReadListener readListener) {
        this.coyoteRequest.setReadListener(readListener);
    }

    public boolean isFinished() {
        int n = 0;
        if (this.state == 2) {
            n = this.bb.remaining();
        } else if (this.state == 1) {
            n = this.cb.remaining();
        }
        if (n > 0) {
            return false;
        }
        return this.coyoteRequest.isFinished();
    }

    public boolean isReady() {
        if (this.coyoteRequest.getReadListener() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("inputBuffer.requiresNonBlocking"));
            }
            return false;
        }
        if (this.isFinished()) {
            if (!this.coyoteRequest.isRequestThread()) {
                this.coyoteRequest.action(ActionCode.DISPATCH_READ, null);
                this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
            }
            return false;
        }
        if (this.availableInThisBuffer() > 0) {
            return true;
        }
        return this.coyoteRequest.isReady();
    }

    boolean isBlocking() {
        return this.coyoteRequest.getReadListener() == null;
    }

    public int realReadBytes() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.state == 0) {
            this.state = 2;
        }
        try {
            return this.coyoteRequest.doRead((ApplicationBufferHandler)this);
        }
        catch (IOException iOException) {
            this.coyoteRequest.setErrorException((Exception)iOException);
            throw new ClientAbortException(iOException);
        }
    }

    public int readByte() throws IOException {
        this.throwIfClosed();
        if (this.checkByteBufferEof()) {
            return -1;
        }
        return this.bb.get() & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.throwIfClosed();
        if (this.checkByteBufferEof()) {
            return -1;
        }
        int n3 = Math.min(n2, this.bb.remaining());
        this.bb.get(byArray, n, n3);
        return n3;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        this.throwIfClosed();
        if (this.checkByteBufferEof()) {
            return -1;
        }
        int n = Math.min(byteBuffer.remaining(), this.bb.remaining());
        int n2 = this.bb.limit();
        this.bb.limit(this.bb.position() + n);
        byteBuffer.put(this.bb);
        this.bb.limit(n2);
        byteBuffer.limit(byteBuffer.position()).position(byteBuffer.position() - n);
        return n;
    }

    @Deprecated
    public void setEncoding(String string) {
        this.enc = string;
    }

    public int realReadChars() throws IOException {
        int n;
        this.checkConverter();
        boolean bl = false;
        if (this.bb.remaining() <= 0 && (n = this.realReadBytes()) < 0) {
            bl = true;
        }
        if (this.markPos == -1) {
            this.clear(this.cb);
        } else {
            this.makeSpace(this.bb.remaining());
            if (this.cb.capacity() - this.cb.limit() == 0 && this.bb.remaining() != 0) {
                this.clear(this.cb);
                this.markPos = -1;
            }
        }
        this.state = 1;
        this.conv.convert(this.bb, this.cb, (ByteChunk.ByteInputChannel)this, bl);
        if (this.cb.remaining() == 0 && bl) {
            return -1;
        }
        return this.cb.remaining();
    }

    @Override
    public int read() throws IOException {
        this.throwIfClosed();
        if (this.checkCharBufferEof()) {
            return -1;
        }
        return this.cb.get();
    }

    @Override
    public int read(char[] cArray) throws IOException {
        this.throwIfClosed();
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.throwIfClosed();
        if (this.checkCharBufferEof()) {
            return -1;
        }
        int n3 = Math.min(n2, this.cb.remaining());
        this.cb.get(cArray, n, n3);
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        this.throwIfClosed();
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        long l2 = 0L;
        while (l2 < l) {
            if ((long)this.cb.remaining() >= l) {
                this.cb.position(this.cb.position() + (int)l);
                l2 = l;
                continue;
            }
            l2 += (long)this.cb.remaining();
            this.cb.position(this.cb.limit());
            int n = this.realReadChars();
            if (n >= 0) continue;
            break;
        }
        return l2;
    }

    @Override
    public boolean ready() throws IOException {
        this.throwIfClosed();
        if (this.state == 0) {
            this.state = 1;
        }
        return this.available() > 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) throws IOException {
        this.throwIfClosed();
        if (this.cb.remaining() <= 0) {
            this.clear(this.cb);
        } else if (this.cb.capacity() > 2 * this.size && this.cb.remaining() < this.cb.position()) {
            this.cb.compact();
            this.cb.flip();
        }
        this.readLimit = this.cb.position() + n + this.size;
        this.markPos = this.cb.position();
    }

    @Override
    public void reset() throws IOException {
        this.throwIfClosed();
        if (this.state == 1) {
            if (this.markPos < 0) {
                this.clear(this.cb);
                this.markPos = -1;
                IOException iOException = new IOException();
                this.coyoteRequest.setErrorException((Exception)iOException);
                throw iOException;
            }
            this.cb.position(this.markPos);
        } else {
            this.clear(this.bb);
        }
    }

    private void throwIfClosed() throws IOException {
        if (this.closed) {
            IOException iOException = new IOException(sm.getString("inputBuffer.streamClosed"));
            this.coyoteRequest.setErrorException((Exception)iOException);
            throw iOException;
        }
    }

    public void checkConverter() throws IOException {
        SynchronizedStack synchronizedStack;
        if (this.conv != null) {
            return;
        }
        Charset charset = this.coyoteRequest.getCharset();
        if (charset == null) {
            charset = this.enc == null ? Constants.DEFAULT_BODY_CHARSET : B2CConverter.getCharset((String)this.enc);
        }
        if ((synchronizedStack = (SynchronizedStack)encoders.get(charset)) == null) {
            synchronizedStack = new SynchronizedStack();
            encoders.putIfAbsent(charset, (SynchronizedStack<B2CConverter>)synchronizedStack);
            synchronizedStack = (SynchronizedStack)encoders.get(charset);
        }
        this.conv = (B2CConverter)synchronizedStack.pop();
        if (this.conv == null) {
            this.conv = InputBuffer.createConverter(charset);
        }
    }

    private static B2CConverter createConverter(final Charset charset) throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<B2CConverter>(){

                    @Override
                    public B2CConverter run() throws IOException {
                        return new B2CConverter(charset);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(exception);
            }
        }
        return new B2CConverter(charset);
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.bb = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.bb;
    }

    public void expand(int n) {
    }

    private boolean checkByteBufferEof() throws IOException {
        int n;
        return this.bb.remaining() == 0 && (n = this.realReadBytes()) < 0;
    }

    private boolean checkCharBufferEof() throws IOException {
        int n;
        return this.cb.remaining() == 0 && (n = this.realReadChars()) < 0;
    }

    private void clear(Buffer buffer) {
        buffer.rewind().limit(0);
    }

    private void makeSpace(int n) {
        int n2 = this.cb.limit() + n;
        if (n2 > this.readLimit) {
            n2 = this.readLimit;
        }
        if (n2 <= this.cb.capacity()) {
            return;
        }
        int n3 = 2 * this.cb.capacity();
        if (n2 >= n3) {
            n3 = 2 * this.cb.capacity() + n;
        }
        if (n3 > this.readLimit) {
            n3 = this.readLimit;
        }
        CharBuffer charBuffer = CharBuffer.allocate(n3);
        int n4 = this.cb.position();
        this.cb.position(0);
        charBuffer.put(this.cb);
        charBuffer.flip();
        charBuffer.position(n4);
        this.cb = charBuffer;
        charBuffer = null;
    }
}

