/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.TDSReader;
import java.io.Serializable;

public final class SQLServerError
extends StreamPacket
implements Serializable {
    private static final long serialVersionUID = -7304033613218700719L;
    private String errorMessage = "";
    private int errorNumber;
    private int errorState;
    private int errorSeverity;
    private String serverName;
    private String procName;
    private long lineNumber;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorNumber() {
        return this.errorNumber;
    }

    public int getErrorState() {
        return this.errorState;
    }

    public int getErrorSeverity() {
        return this.errorSeverity;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getProcedureName() {
        return this.procName;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    SQLServerError() {
        super(170);
    }

    @Override
    void setFromTDS(TDSReader tdsReader) throws SQLServerException {
        if (170 != tdsReader.readUnsignedByte()) assert (false);
        this.setContentsFromTDS(tdsReader);
    }

    void setContentsFromTDS(TDSReader tdsReader) throws SQLServerException {
        tdsReader.readUnsignedShort();
        this.errorNumber = tdsReader.readInt();
        this.errorState = tdsReader.readUnsignedByte();
        this.errorSeverity = tdsReader.readUnsignedByte();
        this.errorMessage = tdsReader.readUnicodeString(tdsReader.readUnsignedShort());
        this.serverName = tdsReader.readUnicodeString(tdsReader.readUnsignedByte());
        this.procName = tdsReader.readUnicodeString(tdsReader.readUnsignedByte());
        this.lineNumber = tdsReader.readUnsignedInt();
    }
}

