/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.node.tasks.cancel;

import java.io.IOException;
import java.util.Arrays;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.support.tasks.BaseTasksRequest;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.tasks.CancellableTask;
import org.opensearch.tasks.Task;

public class CancelTasksRequest
extends BaseTasksRequest<CancelTasksRequest> {
    public static final String DEFAULT_REASON = "by user request";
    public static final boolean DEFAULT_WAIT_FOR_COMPLETION = false;
    private String reason = "by user request";
    private boolean waitForCompletion = false;

    public CancelTasksRequest() {
    }

    public CancelTasksRequest(StreamInput in) throws IOException {
        super(in);
        this.reason = in.readString();
        if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_8_0)) {
            this.waitForCompletion = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.reason);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_8_0)) {
            out.writeBoolean(this.waitForCompletion);
        }
    }

    @Override
    public boolean match(Task task) {
        return super.match(task) && task instanceof CancellableTask;
    }

    public CancelTasksRequest setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public String getDescription() {
        return "reason[" + this.reason + "], waitForCompletion[" + this.waitForCompletion + "], taskId[" + this.getTaskId() + "], parentTaskId[" + this.getParentTaskId() + "], nodes" + Arrays.toString(this.getNodes()) + ", actions" + Arrays.toString(this.getActions());
    }
}

