/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.datastream;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PointValues;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.DefaultShardOperationFailedException;
import org.opensearch.action.support.broadcast.BroadcastRequest;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexAbstractionResolver;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexService;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardNotFoundException;
import org.opensearch.index.store.StoreStats;
import org.opensearch.indices.IndicesService;
import org.opensearch.transport.TransportService;

public class DataStreamsStatsAction
extends ActionType<Response> {
    public static final DataStreamsStatsAction INSTANCE = new DataStreamsStatsAction();
    public static final String NAME = "indices:monitor/data_stream/stats";

    public DataStreamsStatsAction() {
        super(NAME, Response::new);
    }

    public static class TransportAction
    extends TransportBroadcastByNodeAction<Request, Response, DataStreamShardStats> {
        private final ClusterService clusterService;
        private final IndicesService indicesService;
        private final IndexAbstractionResolver indexAbstractionResolver;

        @Inject
        public TransportAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(DataStreamsStatsAction.NAME, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, "management");
            this.clusterService = clusterService;
            this.indicesService = indicesService;
            this.indexAbstractionResolver = new IndexAbstractionResolver(indexNameExpressionResolver);
        }

        @Override
        protected Request readRequestFrom(StreamInput in) throws IOException {
            return new Request(in);
        }

        @Override
        protected ClusterBlockException checkGlobalBlock(ClusterState state, Request request) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        }

        @Override
        protected ClusterBlockException checkRequestBlock(ClusterState state, Request request, String[] concreteIndices) {
            return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
        }

        @Override
        protected ShardsIterator shards(ClusterState clusterState, Request request, String[] concreteIndices) {
            String[] requestIndices = request.indices();
            if (requestIndices == null || requestIndices.length == 0) {
                requestIndices = new String[]{"*"};
            }
            List<String> abstractionNames = this.indexAbstractionResolver.resolveIndexAbstractions(requestIndices, request.indicesOptions(), clusterState.getMetadata(), true);
            SortedMap<String, IndexAbstraction> indicesLookup = clusterState.getMetadata().getIndicesLookup();
            String[] concreteDatastreamIndices = (String[])abstractionNames.stream().flatMap(abstractionName -> {
                IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(abstractionName);
                assert (indexAbstraction != null);
                if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
                    IndexAbstraction.DataStream dataStream = (IndexAbstraction.DataStream)indexAbstraction;
                    List<IndexMetadata> indices = dataStream.getIndices();
                    return indices.stream().map(idx -> idx.getIndex().getName());
                }
                return Stream.empty();
            }).toArray(String[]::new);
            return clusterState.getRoutingTable().allShards(concreteDatastreamIndices);
        }

        @Override
        protected DataStreamShardStats shardOperation(Request request, ShardRouting shardRouting) throws IOException {
            IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
            IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
            if (indexShard.routingEntry() == null) {
                throw new ShardNotFoundException(indexShard.shardId());
            }
            StoreStats storeStats = indexShard.storeStats();
            IndexAbstraction indexAbstraction = (IndexAbstraction)this.clusterService.state().getMetadata().getIndicesLookup().get(shardRouting.getIndexName());
            assert (indexAbstraction != null);
            IndexAbstraction.DataStream dataStream = indexAbstraction.getParentDataStream();
            assert (dataStream != null);
            long maxTimestamp = 0L;
            try (Engine.Searcher searcher = indexShard.acquireSearcher("data_stream_stats");){
                IndexReader indexReader = searcher.getIndexReader();
                String fieldName = dataStream.getDataStream().getTimeStampField().getName();
                byte[] maxPackedValue = PointValues.getMaxPackedValue((IndexReader)indexReader, (String)fieldName);
                if (maxPackedValue != null) {
                    maxTimestamp = LongPoint.decodeDimension((byte[])maxPackedValue, (int)0);
                }
            }
            return new DataStreamShardStats(indexShard.routingEntry(), storeStats, maxTimestamp);
        }

        @Override
        protected DataStreamShardStats readShardResult(StreamInput in) throws IOException {
            return new DataStreamShardStats(in);
        }

        @Override
        protected Response newResponse(Request request, int totalShards, int successfulShards, int failedShards, List<DataStreamShardStats> dataStreamShardStats, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
            HashMap<String, AggregatedStats> aggregatedDataStreamsStats = new HashMap<String, AggregatedStats>();
            HashSet<String> allBackingIndices = new HashSet<String>();
            long totalStoreSizeBytes = 0L;
            SortedMap<String, IndexAbstraction> indicesLookup = clusterState.getMetadata().getIndicesLookup();
            for (DataStreamShardStats shardStat : dataStreamShardStats) {
                String indexName = shardStat.getShardRouting().getIndexName();
                IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(indexName);
                IndexAbstraction.DataStream dataStream = indexAbstraction.getParentDataStream();
                assert (dataStream != null);
                totalStoreSizeBytes += shardStat.getStoreStats().sizeInBytes();
                allBackingIndices.add(indexName);
                AggregatedStats stats = aggregatedDataStreamsStats.computeIfAbsent(dataStream.getName(), s -> new AggregatedStats());
                stats.storageBytes += shardStat.getStoreStats().sizeInBytes();
                stats.maxTimestamp = Math.max(stats.maxTimestamp, shardStat.getMaxTimestamp());
                stats.backingIndices.add(indexName);
            }
            DataStreamStats[] dataStreamStats = (DataStreamStats[])aggregatedDataStreamsStats.entrySet().stream().map(entry -> new DataStreamStats((String)entry.getKey(), ((AggregatedStats)entry.getValue()).backingIndices.size(), new ByteSizeValue(((AggregatedStats)entry.getValue()).storageBytes), ((AggregatedStats)entry.getValue()).maxTimestamp)).toArray(DataStreamStats[]::new);
            return new Response(totalShards, successfulShards, failedShards, shardFailures, aggregatedDataStreamsStats.size(), allBackingIndices.size(), new ByteSizeValue(totalStoreSizeBytes), dataStreamStats);
        }
    }

    private static class AggregatedStats {
        Set<String> backingIndices = new HashSet<String>();
        long storageBytes = 0L;
        long maxTimestamp = 0L;

        private AggregatedStats() {
        }
    }

    public static class DataStreamShardStats
    implements Writeable {
        private final ShardRouting shardRouting;
        private final StoreStats storeStats;
        private final long maxTimestamp;

        public DataStreamShardStats(ShardRouting shardRouting, StoreStats storeStats, long maxTimestamp) {
            this.shardRouting = shardRouting;
            this.storeStats = storeStats;
            this.maxTimestamp = maxTimestamp;
        }

        public DataStreamShardStats(StreamInput in) throws IOException {
            this.shardRouting = new ShardRouting(in);
            this.storeStats = new StoreStats(in);
            this.maxTimestamp = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.shardRouting.writeTo(out);
            this.storeStats.writeTo(out);
            out.writeVLong(this.maxTimestamp);
        }

        public ShardRouting getShardRouting() {
            return this.shardRouting;
        }

        public StoreStats getStoreStats() {
            return this.storeStats;
        }

        public long getMaxTimestamp() {
            return this.maxTimestamp;
        }
    }

    public static class DataStreamStats
    implements ToXContentObject,
    Writeable {
        private final String dataStream;
        private final int backingIndices;
        private final ByteSizeValue storeSize;
        private final long maximumTimestamp;

        public DataStreamStats(String dataStream, int backingIndices, ByteSizeValue storeSize, long maximumTimestamp) {
            this.dataStream = dataStream;
            this.backingIndices = backingIndices;
            this.storeSize = storeSize;
            this.maximumTimestamp = maximumTimestamp;
        }

        public DataStreamStats(StreamInput in) throws IOException {
            this.dataStream = in.readString();
            this.backingIndices = in.readVInt();
            this.storeSize = new ByteSizeValue(in);
            this.maximumTimestamp = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.dataStream);
            out.writeVInt(this.backingIndices);
            this.storeSize.writeTo(out);
            out.writeVLong(this.maximumTimestamp);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("data_stream", this.dataStream);
            builder.field("backing_indices", this.backingIndices);
            builder.humanReadableField("store_size_bytes", "store_size", (Object)this.storeSize);
            builder.field("maximum_timestamp", this.maximumTimestamp);
            builder.endObject();
            return builder;
        }

        public String getDataStream() {
            return this.dataStream;
        }

        public int getBackingIndices() {
            return this.backingIndices;
        }

        public ByteSizeValue getStoreSize() {
            return this.storeSize;
        }

        public long getMaximumTimestamp() {
            return this.maximumTimestamp;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DataStreamStats that = (DataStreamStats)obj;
            return this.backingIndices == that.backingIndices && this.maximumTimestamp == that.maximumTimestamp && Objects.equals(this.dataStream, that.dataStream) && Objects.equals(this.storeSize, that.storeSize);
        }

        public int hashCode() {
            return Objects.hash(this.dataStream, this.backingIndices, this.storeSize, this.maximumTimestamp);
        }

        public String toString() {
            return "DataStreamStats{dataStream='" + this.dataStream + "', backingIndices=" + this.backingIndices + ", storeSize=" + this.storeSize + ", maximumTimestamp=" + this.maximumTimestamp + "}";
        }
    }

    public static class Response
    extends BroadcastResponse {
        private final int dataStreamCount;
        private final int backingIndices;
        private final ByteSizeValue totalStoreSize;
        private final DataStreamStats[] dataStreams;

        public Response(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, int dataStreamCount, int backingIndices, ByteSizeValue totalStoreSize, DataStreamStats[] dataStreams) {
            super(totalShards, successfulShards, failedShards, shardFailures);
            this.dataStreamCount = dataStreamCount;
            this.backingIndices = backingIndices;
            this.totalStoreSize = totalStoreSize;
            this.dataStreams = dataStreams;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.dataStreamCount = in.readVInt();
            this.backingIndices = in.readVInt();
            this.totalStoreSize = new ByteSizeValue(in);
            this.dataStreams = (DataStreamStats[])in.readArray(DataStreamStats::new, DataStreamStats[]::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.dataStreamCount);
            out.writeVInt(this.backingIndices);
            this.totalStoreSize.writeTo(out);
            out.writeArray((Writeable[])this.dataStreams);
        }

        @Override
        protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("data_stream_count", this.dataStreamCount);
            builder.field("backing_indices", this.backingIndices);
            builder.humanReadableField("total_store_size_bytes", "total_store_size", (Object)this.totalStoreSize);
            builder.array("data_streams", (Object[])this.dataStreams);
        }

        public int getDataStreamCount() {
            return this.dataStreamCount;
        }

        public int getBackingIndices() {
            return this.backingIndices;
        }

        public ByteSizeValue getTotalStoreSize() {
            return this.totalStoreSize;
        }

        public DataStreamStats[] getDataStreams() {
            return this.dataStreams;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Response response = (Response)obj;
            return this.dataStreamCount == response.dataStreamCount && this.backingIndices == response.backingIndices && Objects.equals(this.totalStoreSize, response.totalStoreSize) && Arrays.equals(this.dataStreams, response.dataStreams);
        }

        public int hashCode() {
            int result = Objects.hash(this.dataStreamCount, this.backingIndices, this.totalStoreSize);
            result = 31 * result + Arrays.hashCode(this.dataStreams);
            return result;
        }

        public String toString() {
            return "Response{dataStreamCount=" + this.dataStreamCount + ", backingIndices=" + this.backingIndices + ", totalStoreSize=" + this.totalStoreSize + ", dataStreams=" + Arrays.toString(this.dataStreams) + "}";
        }
    }

    public static class Request
    extends BroadcastRequest<Request> {
        public Request() {
            super((String[])null);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }
    }
}

