/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.opensearch.ExceptionsHelper;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class MultiSearchResponse
extends ActionResponse
implements Iterable<Item>,
ToXContentObject {
    private static final ParseField RESPONSES = new ParseField("responses", new String[0]);
    private static final ParseField TOOK_IN_MILLIS = new ParseField("took", new String[0]);
    private static final ConstructingObjectParser<MultiSearchResponse, Void> PARSER = new ConstructingObjectParser("multi_search", true, a -> new MultiSearchResponse(((List)a[0]).toArray(new Item[0]), (Long)a[1]));
    private final Item[] items;
    private final long tookInMillis;

    public MultiSearchResponse(StreamInput in) throws IOException {
        super(in);
        this.items = new Item[in.readVInt()];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new Item(in);
        }
        this.tookInMillis = in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0) ? in.readVLong() : 0L;
    }

    public MultiSearchResponse(Item[] items, long tookInMillis) {
        this.items = items;
        this.tookInMillis = tookInMillis;
    }

    @Override
    public Iterator<Item> iterator() {
        return Arrays.stream(this.items).iterator();
    }

    public Item[] getResponses() {
        return this.items;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.items.length);
        for (Item item : this.items) {
            item.writeTo(out);
        }
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            out.writeVLong(this.tookInMillis);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("took", this.tookInMillis);
        builder.startArray("responses");
        for (Item item : this.items) {
            builder.startObject();
            if (item.isFailure()) {
                OpenSearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)item.getFailure(), (boolean)true);
                builder.field("status", ExceptionsHelper.status((Throwable)item.getFailure()).getStatus());
            } else {
                item.getResponse().innerToXContent(builder, params);
                builder.field("status", item.getResponse().status().getStatus());
            }
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static MultiSearchResponse fromXContext(XContentParser parser) {
        return (MultiSearchResponse)PARSER.apply(parser, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Item itemFromXContent(XContentParser parser) throws IOException {
        Item item = null;
        String fieldName = null;
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        block4: while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    fieldName = parser.currentName();
                    if ("error".equals(fieldName)) {
                        item = new Item(null, (Exception)OpenSearchException.failureFromXContent((XContentParser)parser));
                        break;
                    }
                    if ("status".equals(fieldName)) break;
                    item = new Item(SearchResponse.innerFromXContent(parser), null);
                    break block4;
                }
                case VALUE_NUMBER: {
                    if (!"status".equals(fieldName)) break;
                }
            }
            token = parser.nextToken();
        }
        assert (parser.currentToken() == XContentParser.Token.END_OBJECT);
        return item;
    }

    public String toString() {
        return Strings.toString((MediaType)XContentType.JSON, (ToXContent)this);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> MultiSearchResponse.itemFromXContent(p), RESPONSES);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOOK_IN_MILLIS);
    }

    static final class Fields {
        static final String RESPONSES = "responses";
        static final String STATUS = "status";

        Fields() {
        }
    }

    public static class Item
    implements Writeable {
        private final SearchResponse response;
        private final Exception exception;

        public Item(SearchResponse response, Exception exception) {
            this.response = response;
            this.exception = exception;
        }

        Item(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new SearchResponse(in);
                this.exception = null;
            } else {
                this.exception = in.readException();
                this.response = null;
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeException((Throwable)this.exception);
            }
        }

        public boolean isFailure() {
            return this.exception != null;
        }

        @Nullable
        public String getFailureMessage() {
            return this.exception == null ? null : this.exception.getMessage();
        }

        @Nullable
        public SearchResponse getResponse() {
            return this.response;
        }

        public Exception getFailure() {
            return this.exception;
        }
    }
}

