/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class PutSearchPipelineRequest
extends AcknowledgedRequest<PutSearchPipelineRequest>
implements ToXContentObject {
    private String id;
    private BytesReference source;
    private XContentType xContentType;

    public PutSearchPipelineRequest(String id, BytesReference source, MediaType mediaType) {
        this.id = Objects.requireNonNull(id);
        this.source = Objects.requireNonNull(source);
        if (!(mediaType instanceof XContentType)) {
            throw new IllegalArgumentException(PutSearchPipelineRequest.class.getSimpleName() + " found unsupported media type [" + mediaType.getClass().getName() + "]");
        }
        this.xContentType = XContentType.fromMediaType((MediaType)Objects.requireNonNull(mediaType));
    }

    public PutSearchPipelineRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.source = in.readBytesReference();
        this.xContentType = (XContentType)in.readEnum(XContentType.class);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBytesReference(this.source);
        out.writeEnum((Enum)this.xContentType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source != null) {
            builder.rawValue((InputStream)this.source.streamInput(), (MediaType)this.xContentType);
        } else {
            builder.startObject().endObject();
        }
        return builder;
    }
}

