/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.command;

import java.io.IOException;
import org.opensearch.cluster.routing.allocation.command.AbstractAllocateAllocationCommand;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentBuilder;

public abstract class BasePrimaryAllocationCommand
extends AbstractAllocateAllocationCommand {
    private static final String ACCEPT_DATA_LOSS_FIELD = "accept_data_loss";
    protected final boolean acceptDataLoss;

    protected static <T extends Builder<?>> ObjectParser<T, Void> createAllocatePrimaryParser(String command) {
        ObjectParser parser = BasePrimaryAllocationCommand.createAllocateParser(command);
        parser.declareBoolean(Builder::setAcceptDataLoss, new ParseField(ACCEPT_DATA_LOSS_FIELD, new String[0]));
        return parser;
    }

    protected BasePrimaryAllocationCommand(String index, int shardId, String node, boolean acceptDataLoss) {
        super(index, shardId, node);
        this.acceptDataLoss = acceptDataLoss;
    }

    protected BasePrimaryAllocationCommand(StreamInput in) throws IOException {
        super(in);
        this.acceptDataLoss = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.acceptDataLoss);
    }

    public boolean acceptDataLoss() {
        return this.acceptDataLoss;
    }

    @Override
    protected void extraXContent(XContentBuilder builder) throws IOException {
        builder.field(ACCEPT_DATA_LOSS_FIELD, this.acceptDataLoss);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BasePrimaryAllocationCommand other = (BasePrimaryAllocationCommand)obj;
        return this.acceptDataLoss == other.acceptDataLoss;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Boolean.hashCode(this.acceptDataLoss);
    }

    protected static abstract class Builder<T extends BasePrimaryAllocationCommand>
    extends AbstractAllocateAllocationCommand.Builder<T> {
        protected boolean acceptDataLoss;

        protected Builder() {
        }

        public void setAcceptDataLoss(boolean acceptDataLoss) {
            this.acceptDataLoss = acceptDataLoss;
        }
    }
}

