/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.compress;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.Nullable;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.compress.Compressor;
import org.opensearch.common.compress.DeflateCompressor;
import org.opensearch.common.compress.NoneCompressor;
import org.opensearch.common.compress.NotCompressedException;
import org.opensearch.common.compress.NotXContentException;
import org.opensearch.common.compress.ZstdCompressor;
import org.opensearch.common.xcontent.XContentHelper;

public class CompressorFactory {
    public static final Compressor DEFLATE_COMPRESSOR = new DeflateCompressor();
    public static final Compressor ZSTD_COMPRESSOR = new ZstdCompressor();
    public static final Compressor NONE_COMPRESSOR = new NoneCompressor();

    public static boolean isCompressed(BytesReference bytes) {
        return CompressorFactory.compressor(bytes) != null;
    }

    public static Compressor defaultCompressor() {
        return DEFLATE_COMPRESSOR;
    }

    @Nullable
    public static Compressor compressor(BytesReference bytes) {
        if (DEFLATE_COMPRESSOR.isCompressed(bytes)) {
            assert (XContentHelper.xContentType(bytes) == null);
            return DEFLATE_COMPRESSOR;
        }
        if (ZSTD_COMPRESSOR.isCompressed(bytes)) {
            assert (XContentHelper.xContentType(bytes) == null);
            return ZSTD_COMPRESSOR;
        }
        if (XContentHelper.xContentType(bytes) == null) {
            throw new NotXContentException("Compressor detection can only be called on some xcontent bytes or compressed xcontent bytes");
        }
        return null;
    }

    public static BytesReference uncompressIfNeeded(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(Objects.requireNonNull(bytes, "the BytesReference must not be null"));
        return compressor == null ? bytes : compressor.uncompress(bytes);
    }

    public static BytesReference uncompress(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor == null) {
            throw new NotCompressedException();
        }
        return compressor.uncompress(bytes);
    }
}

