/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo;

import java.io.IOException;
import java.text.ParseException;
import java.util.Objects;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.geo.GeoUtils;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.Rectangle;
import org.opensearch.geometry.ShapeType;
import org.opensearch.geometry.utils.GeometryValidator;
import org.opensearch.geometry.utils.StandardValidator;
import org.opensearch.geometry.utils.WellKnownText;

public class GeoBoundingBox
implements ToXContentObject,
Writeable {
    private static final WellKnownText WKT_PARSER = new WellKnownText(true, (GeometryValidator)new StandardValidator(true));
    static final ParseField TOP_RIGHT_FIELD = new ParseField("top_right", new String[0]);
    static final ParseField BOTTOM_LEFT_FIELD = new ParseField("bottom_left", new String[0]);
    static final ParseField TOP_FIELD = new ParseField("top", new String[0]);
    static final ParseField BOTTOM_FIELD = new ParseField("bottom", new String[0]);
    static final ParseField LEFT_FIELD = new ParseField("left", new String[0]);
    static final ParseField RIGHT_FIELD = new ParseField("right", new String[0]);
    static final ParseField WKT_FIELD = new ParseField("wkt", new String[0]);
    public static final ParseField BOUNDS_FIELD = new ParseField("bounds", new String[0]);
    public static final ParseField LAT_FIELD = new ParseField("lat", new String[0]);
    public static final ParseField LON_FIELD = new ParseField("lon", new String[0]);
    public static final ParseField TOP_LEFT_FIELD = new ParseField("top_left", new String[0]);
    public static final ParseField BOTTOM_RIGHT_FIELD = new ParseField("bottom_right", new String[0]);
    private final GeoPoint topLeft;
    private final GeoPoint bottomRight;

    public GeoBoundingBox(GeoPoint topLeft, GeoPoint bottomRight) {
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
    }

    public GeoBoundingBox(StreamInput input) throws IOException {
        this.topLeft = new GeoPoint(input);
        this.bottomRight = new GeoPoint(input);
    }

    public boolean isUnbounded() {
        return Double.isNaN(this.topLeft.lon()) || Double.isNaN(this.topLeft.lat()) || Double.isNaN(this.bottomRight.lon()) || Double.isNaN(this.bottomRight.lat());
    }

    public GeoPoint topLeft() {
        return this.topLeft;
    }

    public GeoPoint bottomRight() {
        return this.bottomRight;
    }

    public double top() {
        return this.topLeft.lat();
    }

    public double bottom() {
        return this.bottomRight.lat();
    }

    public double left() {
        return this.topLeft.lon();
    }

    public double right() {
        return this.bottomRight.lon();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(BOUNDS_FIELD.getPreferredName());
        this.toXContentFragment(builder, true);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, boolean buildLatLonFields) throws IOException {
        if (buildLatLonFields) {
            builder.startObject(TOP_LEFT_FIELD.getPreferredName());
            builder.field(LAT_FIELD.getPreferredName(), this.topLeft.lat());
            builder.field(LON_FIELD.getPreferredName(), this.topLeft.lon());
            builder.endObject();
        } else {
            builder.array(TOP_LEFT_FIELD.getPreferredName(), new Object[]{this.topLeft.lon(), this.topLeft.lat()});
        }
        if (buildLatLonFields) {
            builder.startObject(BOTTOM_RIGHT_FIELD.getPreferredName());
            builder.field(LAT_FIELD.getPreferredName(), this.bottomRight.lat());
            builder.field(LON_FIELD.getPreferredName(), this.bottomRight.lon());
            builder.endObject();
        } else {
            builder.array(BOTTOM_RIGHT_FIELD.getPreferredName(), new Object[]{this.bottomRight.lon(), this.bottomRight.lat()});
        }
        return builder;
    }

    public boolean pointInBounds(double lon, double lat) {
        if (lat >= this.bottom() && lat <= this.top()) {
            if (this.left() <= this.right()) {
                return lon >= this.left() && lon <= this.right();
            }
            return lon >= this.left() || lon <= this.right();
        }
        return false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.topLeft.writeTo(out);
        this.bottomRight.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoBoundingBox that = (GeoBoundingBox)o;
        return this.topLeft.equals(that.topLeft) && this.bottomRight.equals(that.bottomRight);
    }

    public int hashCode() {
        return Objects.hash(this.topLeft, this.bottomRight);
    }

    public String toString() {
        return "BBOX (" + this.topLeft.lon() + ", " + this.bottomRight.lon() + ", " + this.topLeft.lat() + ", " + this.bottomRight.lat() + ")";
    }

    public static GeoBoundingBox parseBoundingBox(XContentParser parser) throws IOException, OpenSearchParseException {
        GeoPoint topLeft;
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new OpenSearchParseException("failed to parse bounding box. Expected start object but found [{}]", token);
        }
        double top = Double.NaN;
        double bottom = Double.NaN;
        double left = Double.NaN;
        double right = Double.NaN;
        GeoPoint sparse = new GeoPoint();
        Rectangle envelope = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                token = parser.nextToken();
                if (WKT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        Geometry geometry = WKT_PARSER.fromWKT(parser.text());
                        if (!ShapeType.ENVELOPE.equals((Object)geometry.type())) {
                            throw new OpenSearchParseException("failed to parse WKT bounding box. [" + geometry.type() + "] found. expected [" + ShapeType.ENVELOPE + "]", new Object[0]);
                        }
                        envelope = (Rectangle)geometry;
                        continue;
                    }
                    catch (IllegalArgumentException | ParseException e) {
                        throw new OpenSearchParseException("failed to parse WKT bounding box", e, new Object[0]);
                    }
                }
                if (TOP_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    top = parser.doubleValue();
                    continue;
                }
                if (BOTTOM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    bottom = parser.doubleValue();
                    continue;
                }
                if (LEFT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    left = parser.doubleValue();
                    continue;
                }
                if (RIGHT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    right = parser.doubleValue();
                    continue;
                }
                if (TOP_LEFT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    GeoUtils.parseGeoPoint(parser, sparse, false, GeoUtils.EffectivePoint.TOP_LEFT);
                    top = sparse.getLat();
                    left = sparse.getLon();
                    continue;
                }
                if (BOTTOM_RIGHT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    GeoUtils.parseGeoPoint(parser, sparse, false, GeoUtils.EffectivePoint.BOTTOM_RIGHT);
                    bottom = sparse.getLat();
                    right = sparse.getLon();
                    continue;
                }
                if (TOP_RIGHT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    GeoUtils.parseGeoPoint(parser, sparse, false, GeoUtils.EffectivePoint.TOP_RIGHT);
                    top = sparse.getLat();
                    right = sparse.getLon();
                    continue;
                }
                if (BOTTOM_LEFT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    GeoUtils.parseGeoPoint(parser, sparse, false, GeoUtils.EffectivePoint.BOTTOM_LEFT);
                    bottom = sparse.getLat();
                    left = sparse.getLon();
                    continue;
                }
                throw new OpenSearchParseException("failed to parse bounding box. unexpected field [{}]", currentFieldName);
            }
            throw new OpenSearchParseException("failed to parse bounding box. field name expected but [{}] found", token);
        }
        if (envelope != null) {
            if (!(Double.isNaN(top) && Double.isNaN(bottom) && Double.isNaN(left) && Double.isNaN(right))) {
                throw new OpenSearchParseException("failed to parse bounding box. Conflicting definition found using well-known text and explicit corners.", new Object[0]);
            }
            topLeft = new GeoPoint(envelope.getMaxLat(), envelope.getMinLon());
            GeoPoint bottomRight = new GeoPoint(envelope.getMinLat(), envelope.getMaxLon());
            return new GeoBoundingBox(topLeft, bottomRight);
        }
        topLeft = new GeoPoint(top, left);
        GeoPoint bottomRight = new GeoPoint(bottom, right);
        return new GeoBoundingBox(topLeft, bottomRight);
    }
}

