/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.settings;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;

public class WriteableSetting
implements Writeable {
    private Setting<?> setting;
    private SettingType type;

    public WriteableSetting(Setting<?> setting) {
        this(setting, WriteableSetting.getGenericTypeFromDefault(setting));
    }

    public WriteableSetting(Setting<?> setting, SettingType type) {
        this.setting = setting;
        this.type = type;
    }

    public WriteableSetting(StreamInput in) throws IOException {
        this.type = (SettingType)in.readEnum(SettingType.class);
        String key = in.readString();
        Object defaultValue = this.readDefaultValue(in);
        WriteableSetting fallback = null;
        boolean hasFallback = in.readBoolean();
        if (hasFallback) {
            fallback = new WriteableSetting(in);
        }
        Object parser = null;
        boolean isParserWriteable = in.readBoolean();
        if (isParserWriteable) {
            parser = this.readParser(in, parser);
        }
        Object validator = new Object();
        boolean isValidatorWriteable = in.readBoolean();
        if (isValidatorWriteable) {
            validator = this.readValidator(in);
        }
        EnumSet propSet = in.readEnumSet(Setting.Property.class);
        this.setting = this.createSetting(this.type, key, defaultValue, parser, validator, fallback, (Setting.Property[])propSet.toArray(Setting.Property[]::new));
    }

    private static SettingType getGenericTypeFromDefault(Setting<?> setting) {
        String typeStr = setting.getDefault(Settings.EMPTY).getClass().getSimpleName();
        try {
            return SettingType.valueOf(typeStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("This class is not yet set up to handle the generic type: " + typeStr + ". Supported types are " + Arrays.toString((Object[])SettingType.values()));
        }
    }

    public Setting<?> getSetting() {
        return this.setting;
    }

    public SettingType getType() {
        return this.type;
    }

    private Setting<?> createSetting(SettingType type, String key, Object defaultValue, @Nullable Object parser, Object validator, WriteableSetting fallback, Setting.Property[] propertyArray) {
        switch (type) {
            case Boolean: {
                return fallback == null ? Setting.boolSetting(key, (boolean)((Boolean)defaultValue), propertyArray) : Setting.boolSetting(key, fallback.getSetting(), propertyArray);
            }
            case Integer: {
                if (fallback == null && parser instanceof Writeable) {
                    return Setting.intSetting(key, (int)((Integer)defaultValue), ((Setting.IntegerParser)parser).getMin(), ((Setting.IntegerParser)parser).getMax(), propertyArray);
                }
                if (fallback == null) {
                    return Setting.intSetting(key, (int)((Integer)defaultValue), propertyArray);
                }
                return Setting.intSetting(key, fallback.getSetting(), propertyArray);
            }
            case Long: {
                if (fallback == null && parser instanceof Writeable) {
                    return Setting.longSetting(key, (long)((Long)defaultValue), ((Setting.LongParser)parser).getMin(), ((Setting.LongParser)parser).getMax(), propertyArray);
                }
                if (fallback == null) {
                    return Setting.longSetting(key, (long)((Long)defaultValue), propertyArray);
                }
                return Setting.longSetting(key, fallback.getSetting(), propertyArray);
            }
            case Float: {
                if (fallback == null && parser instanceof Writeable) {
                    return Setting.floatSetting(key, ((Float)defaultValue).floatValue(), ((Setting.FloatParser)parser).getMin(), ((Setting.FloatParser)parser).getMax(), propertyArray);
                }
                if (fallback == null) {
                    return Setting.floatSetting(key, ((Float)defaultValue).floatValue(), propertyArray);
                }
                return Setting.floatSetting(key, fallback.getSetting(), propertyArray);
            }
            case Double: {
                if (fallback == null && parser instanceof Writeable) {
                    return Setting.doubleSetting(key, (double)((Double)defaultValue), ((Setting.DoubleParser)parser).getMin(), ((Setting.DoubleParser)parser).getMax(), propertyArray);
                }
                if (fallback == null) {
                    return Setting.doubleSetting(key, (double)((Double)defaultValue), propertyArray);
                }
                return Setting.doubleSetting(key, fallback.getSetting(), propertyArray);
            }
            case String: {
                return fallback == null ? Setting.simpleString(key, (String)defaultValue, propertyArray) : Setting.simpleString(key, fallback.getSetting(), propertyArray);
            }
            case TimeValue: {
                if (fallback == null && parser instanceof Writeable) {
                    if (parser instanceof Setting.MinMaxTimeValueParser) {
                        return Setting.timeSetting(key, (TimeValue)defaultValue, ((Setting.MinMaxTimeValueParser)parser).getMin(), ((Setting.MinMaxTimeValueParser)parser).getMax(), propertyArray);
                    }
                    return Setting.timeSetting(key, (TimeValue)defaultValue, ((Setting.MinTimeValueParser)parser).getMin(), propertyArray);
                }
                if (fallback == null) {
                    return Setting.timeSetting(key, (TimeValue)defaultValue, propertyArray);
                }
                return Setting.timeSetting(key, fallback.getSetting(), propertyArray);
            }
            case ByteSizeValue: {
                if (fallback == null && parser instanceof Writeable) {
                    if (parser instanceof Setting.MemorySizeValueParser) {
                        return Setting.memorySizeSetting(key, (ByteSizeValue)defaultValue, propertyArray);
                    }
                    Setting.ByteSizeValueParser byteSizeValueParser = (Setting.ByteSizeValueParser)parser;
                    return Setting.byteSizeSetting(key, (ByteSizeValue)defaultValue, byteSizeValueParser.getMin(), byteSizeValueParser.getMax(), propertyArray);
                }
                if (fallback == null) {
                    return Setting.byteSizeSetting(key, (ByteSizeValue)defaultValue, propertyArray);
                }
                return Setting.byteSizeSetting(key, fallback.getSetting(), propertyArray);
            }
            case Version: {
                return Setting.versionSetting(key, (Version)defaultValue, propertyArray);
            }
        }
        throw new IllegalArgumentException("A SettingType has been added to the enum and not handled here.");
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.type);
        out.writeString(this.setting.getKey());
        this.writeDefaultValue(out, this.setting.getDefault(Settings.EMPTY));
        boolean hasFallback = this.setting.fallbackSetting != null;
        out.writeBoolean(hasFallback);
        if (hasFallback) {
            new WriteableSetting(this.setting.fallbackSetting, this.type).writeTo(out);
        }
        boolean isParserWriteable = this.setting.parser instanceof Writeable;
        out.writeBoolean(isParserWriteable);
        if (isParserWriteable) {
            this.writeParser(out, this.setting.parser);
        }
        boolean isValidatorWriteable = this.setting.validator instanceof Writeable;
        out.writeBoolean(isValidatorWriteable);
        if (isValidatorWriteable) {
            this.writeValidator(out, this.setting.validator);
        }
        out.writeEnumSet(this.setting.getProperties());
    }

    private void writeParser(StreamOutput out, Object parser) throws IOException {
        switch (this.type) {
            case Integer: {
                ((Setting.IntegerParser)parser).writeTo(out);
                break;
            }
            case Long: {
                ((Setting.LongParser)parser).writeTo(out);
                break;
            }
            case Float: {
                ((Setting.FloatParser)parser).writeTo(out);
                break;
            }
            case Double: {
                ((Setting.DoubleParser)parser).writeTo(out);
                break;
            }
            case TimeValue: {
                if (parser instanceof Setting.MinMaxTimeValueParser) {
                    out.writeBoolean(true);
                    ((Setting.MinMaxTimeValueParser)parser).writeTo(out);
                    break;
                }
                if (!(parser instanceof Setting.MinTimeValueParser)) break;
                out.writeBoolean(false);
                ((Setting.MinTimeValueParser)parser).writeTo(out);
                break;
            }
            case ByteSizeValue: {
                if (parser instanceof Setting.ByteSizeValueParser) {
                    out.writeBoolean(true);
                    ((Setting.ByteSizeValueParser)parser).writeTo(out);
                    break;
                }
                if (!(parser instanceof Setting.MemorySizeValueParser)) break;
                out.writeBoolean(false);
                ((Setting.MemorySizeValueParser)parser).writeTo(out);
                break;
            }
            default: {
                throw new IllegalArgumentException("A SettingType has been added to the enum and not handled here.");
            }
        }
    }

    private void writeValidator(StreamOutput out, Object validator) throws IOException {
        ((Writeable)validator).writeTo(out);
    }

    private void writeDefaultValue(StreamOutput out, Object defaultValue) throws IOException {
        switch (this.type) {
            case Boolean: {
                out.writeBoolean(((Boolean)defaultValue).booleanValue());
                break;
            }
            case Integer: {
                out.writeInt(((Integer)defaultValue).intValue());
                break;
            }
            case Long: {
                out.writeLong(((Long)defaultValue).longValue());
                break;
            }
            case Float: {
                out.writeFloat(((Float)defaultValue).floatValue());
                break;
            }
            case Double: {
                out.writeDouble(((Double)defaultValue).doubleValue());
                break;
            }
            case String: {
                out.writeString((String)defaultValue);
                break;
            }
            case TimeValue: {
                TimeValue tv = (TimeValue)defaultValue;
                out.writeLong(tv.duration());
                out.writeString(tv.timeUnit().name());
                break;
            }
            case ByteSizeValue: {
                ((ByteSizeValue)defaultValue).writeTo(out);
                break;
            }
            case Version: {
                out.writeVersion((Version)defaultValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("A SettingType has been added to the enum and not handled here.");
            }
        }
    }

    private Object readParser(StreamInput in, Object parser) throws IOException {
        switch (this.type) {
            case Integer: {
                return new Setting.IntegerParser(in);
            }
            case Long: {
                return new Setting.LongParser(in);
            }
            case Float: {
                return new Setting.FloatParser(in);
            }
            case Double: {
                return new Setting.DoubleParser(in);
            }
            case TimeValue: {
                if (in.readBoolean()) {
                    return new Setting.MinMaxTimeValueParser(in);
                }
                return new Setting.MinTimeValueParser(in);
            }
            case ByteSizeValue: {
                if (in.readBoolean()) {
                    return new Setting.ByteSizeValueParser(in);
                }
                return new Setting.MemorySizeValueParser(in);
            }
        }
        throw new IllegalArgumentException("A SettingType has been added to the enum and not handled here.");
    }

    private Object readValidator(StreamInput in) throws IOException {
        return new Setting.RegexValidator(in);
    }

    private Object readDefaultValue(StreamInput in) throws IOException {
        switch (this.type) {
            case Boolean: {
                return in.readBoolean();
            }
            case Integer: {
                return in.readInt();
            }
            case Long: {
                return in.readLong();
            }
            case Float: {
                return Float.valueOf(in.readFloat());
            }
            case Double: {
                return in.readDouble();
            }
            case String: {
                return in.readString();
            }
            case TimeValue: {
                long duration = in.readLong();
                TimeUnit unit = TimeUnit.valueOf(in.readString());
                return new TimeValue(duration, unit);
            }
            case ByteSizeValue: {
                return new ByteSizeValue(in);
            }
            case Version: {
                return in.readVersion();
            }
        }
        throw new IllegalArgumentException("A SettingType has been added to the enum and not handled here.");
    }

    public String toString() {
        return "WriteableSettings{type=Setting<" + this.type + ">, setting=" + this.setting + "}";
    }

    public static enum SettingType {
        Boolean,
        Integer,
        Long,
        Float,
        Double,
        String,
        TimeValue,
        ByteSizeValue,
        Version;

    }
}

