/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.compress.Compressor;
import org.opensearch.common.compress.CompressorFactory;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;

public class XContentHelper {
    @Deprecated
    public static XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            InputStream compressedInput = null;
            try {
                compressedInput = compressor.threadLocalInputStream((InputStream)bytes.streamInput());
                if (!compressedInput.markSupported()) {
                    compressedInput = new BufferedInputStream(compressedInput);
                }
                XContentType contentType = XContentFactory.xContentType((InputStream)compressedInput);
                return XContentFactory.xContent((MediaType)contentType).createParser(xContentRegistry, deprecationHandler, compressedInput);
            }
            catch (Exception e) {
                if (compressedInput != null) {
                    compressedInput.close();
                }
                throw e;
            }
        }
        return XContentFactory.xContent((MediaType)XContentHelper.xContentType(bytes)).createParser(xContentRegistry, deprecationHandler, (InputStream)bytes.streamInput());
    }

    public static XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, BytesReference bytes, MediaType mediaType) throws IOException {
        Objects.requireNonNull(mediaType);
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            InputStream compressedInput = null;
            try {
                compressedInput = compressor.threadLocalInputStream((InputStream)bytes.streamInput());
                if (!compressedInput.markSupported()) {
                    compressedInput = new BufferedInputStream(compressedInput);
                }
                return XContentFactory.xContent((MediaType)mediaType).createParser(xContentRegistry, deprecationHandler, compressedInput);
            }
            catch (Exception e) {
                if (compressedInput != null) {
                    compressedInput.close();
                }
                throw e;
            }
        }
        if (bytes instanceof BytesArray) {
            BytesArray array = (BytesArray)bytes;
            return mediaType.xContent().createParser(xContentRegistry, deprecationHandler, array.array(), array.offset(), array.length());
        }
        return mediaType.xContent().createParser(xContentRegistry, deprecationHandler, (InputStream)bytes.streamInput());
    }

    @Deprecated
    public static Tuple<XContentType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered) throws OpenSearchParseException {
        return XContentHelper.convertToMap(bytes, ordered, null);
    }

    @Deprecated
    public static Tuple<XContentType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered, XContentType xContentType) {
        if (!Objects.isNull(xContentType) && !(xContentType instanceof XContentType)) {
            throw new IllegalArgumentException("XContentHelper.convertToMap does not support media type [" + xContentType.getClass().getName() + "]");
        }
        return XContentHelper.convertToMap(bytes, ordered, (MediaType)xContentType);
    }

    public static Tuple<? extends MediaType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered, MediaType xContentType) throws OpenSearchParseException {
        Tuple tuple;
        block12: {
            Object input;
            Compressor compressor = CompressorFactory.compressor(bytes);
            if (compressor != null) {
                InputStream compressedStreamInput = compressor.threadLocalInputStream((InputStream)bytes.streamInput());
                if (!compressedStreamInput.markSupported()) {
                    compressedStreamInput = new BufferedInputStream(compressedStreamInput);
                }
                input = compressedStreamInput;
            } else {
                if (bytes instanceof BytesArray) {
                    BytesArray arr = (BytesArray)bytes;
                    byte[] raw = arr.array();
                    int offset = arr.offset();
                    int length = arr.length();
                    MediaType contentType = xContentType != null ? xContentType : XContentFactory.xContentType((byte[])raw, (int)offset, (int)length);
                    return new Tuple((Object)Objects.requireNonNull(contentType), XContentHelper.convertToMap(XContentFactory.xContent((MediaType)contentType), raw, offset, length, ordered));
                }
                input = bytes.streamInput();
            }
            StreamInput stream = input;
            try {
                MediaType contentType = xContentType != null ? xContentType : XContentFactory.xContentType((InputStream)stream);
                tuple = new Tuple((Object)Objects.requireNonNull(contentType), XContentHelper.convertToMap(XContentFactory.xContent((MediaType)contentType), (InputStream)stream, ordered));
                if (stream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OpenSearchParseException("Failed to parse content to map", e, new Object[0]);
                }
            }
            stream.close();
        }
        return tuple;
    }

    public static Map<String, Object> convertToMap(XContent xContent, String string, boolean ordered) throws OpenSearchParseException {
        Map map;
        block8: {
            XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, string);
            try {
                Map map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OpenSearchParseException("Failed to parse content to map", e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    public static Map<String, Object> convertToMap(XContent xContent, InputStream input, boolean ordered) throws OpenSearchParseException {
        Map map;
        block8: {
            XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, input);
            try {
                Map map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OpenSearchParseException("Failed to parse content to map", e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    public static Map<String, Object> convertToMap(XContent xContent, byte[] bytes, int offset, int length, boolean ordered) throws OpenSearchParseException {
        Map map;
        block8: {
            XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, bytes, offset, length);
            try {
                Map map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OpenSearchParseException("Failed to parse content to map", e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    @Deprecated
    public static String convertToJson(BytesReference bytes, boolean reformatJson) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, false);
    }

    @Deprecated
    public static String convertToJson(BytesReference bytes, boolean reformatJson, boolean prettyPrint) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, prettyPrint, XContentFactory.xContentType((byte[])bytes.toBytesRef().bytes));
    }

    public static String convertToJson(BytesReference bytes, boolean reformatJson, MediaType xContentType) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, false, xContentType);
    }

    public static String stripWhitespace(String json) throws IOException {
        return XContentHelper.convertToJson((BytesReference)new BytesArray(json), true, (MediaType)XContentType.JSON);
    }

    @Deprecated
    public static String convertToJson(BytesReference bytes, boolean reformatJson, boolean prettyPrint, XContentType xContentType) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, prettyPrint, (MediaType)xContentType);
    }

    public static String convertToJson(BytesReference bytes, boolean reformatJson, boolean prettyPrint, MediaType mediaType) throws IOException {
        Objects.requireNonNull(mediaType);
        if (mediaType == XContentType.JSON && !reformatJson) {
            return bytes.utf8ToString();
        }
        if (bytes instanceof BytesArray) {
            BytesArray array = (BytesArray)bytes;
            try (XContentParser parser = XContentFactory.xContent((MediaType)mediaType).createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, array.array(), array.offset(), array.length());){
                String string = XContentHelper.toJsonString(prettyPrint, parser);
                return string;
            }
        }
        try (StreamInput stream = bytes.streamInput();){
            String string;
            block20: {
                XContentParser parser = XContentFactory.xContent((MediaType)mediaType).createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)stream);
                try {
                    string = XContentHelper.toJsonString(prettyPrint, parser);
                    if (parser == null) break block20;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return string;
        }
    }

    private static String toJsonString(boolean prettyPrint, XContentParser parser) throws IOException {
        parser.nextToken();
        XContentBuilder builder = XContentFactory.jsonBuilder();
        if (prettyPrint) {
            builder.prettyPrint();
        }
        builder.copyCurrentStructure(parser);
        return Strings.toString(builder);
    }

    public static boolean update(Map<String, Object> source, Map<String, Object> changes, boolean checkUpdatesAreUnequal) {
        boolean modified = false;
        for (Map.Entry<String, Object> changesEntry : changes.entrySet()) {
            if (!source.containsKey(changesEntry.getKey())) {
                source.put(changesEntry.getKey(), changesEntry.getValue());
                modified = true;
                continue;
            }
            Object old = source.get(changesEntry.getKey());
            if (old instanceof Map && changesEntry.getValue() instanceof Map) {
                modified |= XContentHelper.update((Map)source.get(changesEntry.getKey()), (Map)changesEntry.getValue(), checkUpdatesAreUnequal && !modified);
                continue;
            }
            source.put(changesEntry.getKey(), changesEntry.getValue());
            if (modified) continue;
            if (!checkUpdatesAreUnequal) {
                modified = true;
                continue;
            }
            modified = !Objects.equals(old, changesEntry.getValue());
        }
        return modified;
    }

    public static void mergeDefaults(Map<String, Object> content, Map<String, Object> defaults) {
        for (Map.Entry<String, Object> defaultEntry : defaults.entrySet()) {
            if (!content.containsKey(defaultEntry.getKey())) {
                content.put(defaultEntry.getKey(), defaultEntry.getValue());
                continue;
            }
            if (content.get(defaultEntry.getKey()) instanceof Map && defaultEntry.getValue() instanceof Map) {
                XContentHelper.mergeDefaults((Map)content.get(defaultEntry.getKey()), (Map)defaultEntry.getValue());
                continue;
            }
            if (!(content.get(defaultEntry.getKey()) instanceof List) || !(defaultEntry.getValue() instanceof List)) continue;
            List defaultList = (List)defaultEntry.getValue();
            List contentList = (List)content.get(defaultEntry.getKey());
            ArrayList mergedList = new ArrayList();
            if (XContentHelper.allListValuesAreMapsOfOne(defaultList) && XContentHelper.allListValuesAreMapsOfOne(contentList)) {
                Map.Entry entry;
                Map map;
                LinkedHashMap<String, Map> processed = new LinkedHashMap<String, Map>();
                for (Object o : contentList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    processed.put((String)entry.getKey(), map);
                }
                for (Object o : defaultList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    if (processed.containsKey(entry.getKey())) {
                        XContentHelper.mergeDefaults((Map)processed.get(entry.getKey()), map);
                        continue;
                    }
                    processed.put((String)entry.getKey(), map);
                }
                for (Map map2 : processed.values()) {
                    mergedList.add(map2);
                }
            } else {
                mergedList.addAll(defaultList);
                for (Object o : contentList) {
                    if (mergedList.contains(o)) continue;
                    mergedList.add(o);
                }
            }
            content.put(defaultEntry.getKey(), mergedList);
        }
    }

    private static boolean allListValuesAreMapsOfOne(List list) {
        for (Object o : list) {
            if (!(o instanceof Map)) {
                return false;
            }
            if (((Map)o).size() == 1) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static void writeRawField(String field, BytesReference source, XContentBuilder builder, ToXContent.Params params) throws IOException {
        Compressor compressor = CompressorFactory.compressor(source);
        if (compressor != null) {
            try (InputStream compressedStreamInput = compressor.threadLocalInputStream((InputStream)source.streamInput());){
                builder.rawField(field, compressedStreamInput);
            }
        }
        try (StreamInput stream = source.streamInput();){
            builder.rawField(field, (InputStream)stream);
        }
    }

    public static void writeRawField(String field, BytesReference source, XContentType xContentType, XContentBuilder builder, ToXContent.Params params) throws IOException {
        Objects.requireNonNull(xContentType);
        Compressor compressor = CompressorFactory.compressor(source);
        if (compressor != null) {
            try (InputStream compressedStreamInput = compressor.threadLocalInputStream((InputStream)source.streamInput());){
                builder.rawField(field, compressedStreamInput, (MediaType)xContentType);
            }
        }
        try (StreamInput stream = source.streamInput();){
            builder.rawField(field, (InputStream)stream, (MediaType)xContentType);
        }
    }

    public static BytesReference toXContent(ToXContent toXContent, XContentType xContentType, boolean humanReadable) throws IOException {
        return XContentHelper.toXContent(toXContent, xContentType, ToXContent.EMPTY_PARAMS, humanReadable);
    }

    @Deprecated
    public static BytesReference toXContent(ToXContent toXContent, XContentType xContentType, ToXContent.Params params, boolean humanReadable) throws IOException {
        try (XContentBuilder builder = XContentBuilder.builder((XContent)xContentType.xContent());){
            builder.humanReadable(humanReadable);
            if (toXContent.isFragment()) {
                builder.startObject();
            }
            toXContent.toXContent(builder, params);
            if (toXContent.isFragment()) {
                builder.endObject();
            }
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
    }

    public static BytesReference toXContent(ToXContent toXContent, MediaType mediaType, ToXContent.Params params, boolean humanReadable) throws IOException {
        try (XContentBuilder builder = XContentBuilder.builder((XContent)mediaType.xContent());){
            builder.humanReadable(humanReadable);
            if (toXContent.isFragment()) {
                builder.startObject();
            }
            toXContent.toXContent(builder, params);
            if (toXContent.isFragment()) {
                builder.endObject();
            }
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
    }

    @Deprecated
    public static XContentType xContentType(BytesReference bytes) {
        if (bytes instanceof BytesArray) {
            BytesArray array = (BytesArray)bytes;
            return XContentFactory.xContentType((byte[])array.array(), (int)array.offset(), (int)array.length());
        }
        try {
            StreamInput inputStream = bytes.streamInput();
            assert (inputStream.markSupported());
            return XContentFactory.xContentType((InputStream)inputStream);
        }
        catch (IOException e) {
            assert (false) : "Should not happen, we're just reading bytes from memory";
            throw new UncheckedIOException(e);
        }
    }

    public static BytesReference childBytes(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(parser.getTokenLocation(), "Expected [START_OBJECT] but got [" + parser.currentToken() + "]");
        }
        XContentBuilder builder = XContentBuilder.builder((XContent)parser.contentType().xContent());
        builder.copyCurrentStructure(parser);
        return BytesReference.bytes((XContentBuilder)builder);
    }
}

