/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import java.text.ParseException;
import java.util.Objects;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.index.store.Store;

public class StoreFileMetadata
implements Writeable {
    private final String name;
    private final long length;
    private final String checksum;
    private final Version writtenBy;
    private final BytesRef hash;

    public StoreFileMetadata(String name, long length, String checksum, Version writtenBy) {
        this(name, length, checksum, writtenBy, null);
    }

    public StoreFileMetadata(String name, long length, String checksum, Version writtenBy, BytesRef hash) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.length = length;
        this.checksum = Objects.requireNonNull(checksum, "checksum must not be null");
        this.writtenBy = Objects.requireNonNull(writtenBy, "writtenBy must not be null");
        this.hash = hash == null ? new BytesRef() : hash;
    }

    public StoreFileMetadata(StreamInput in) throws IOException {
        this.name = in.readString();
        this.length = in.readVLong();
        this.checksum = in.readString();
        try {
            this.writtenBy = Version.parse((String)in.readString());
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
        this.hash = in.readBytesRef();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVLong(this.length);
        out.writeString(this.checksum);
        out.writeString(this.writtenBy.toString());
        out.writeBytesRef(this.hash);
    }

    public String name() {
        return this.name;
    }

    public long length() {
        return this.length;
    }

    public String checksum() {
        return this.checksum;
    }

    public boolean hashEqualsContents() {
        if ((long)this.hash.length == this.length) {
            try {
                boolean checksumsMatch = Store.digestToString(CodecUtil.retrieveChecksum((IndexInput)new ByteArrayIndexInput("store_file", this.hash.bytes, this.hash.offset, this.hash.length))).equals(this.checksum);
                assert (checksumsMatch) : "Checksums did not match for [" + this + "] which has a hash of [" + this.hash + "]";
                return checksumsMatch;
            }
            catch (Exception e) {
                assert (false) : new AssertionError("Saw exception for hash [" + this.hash + "] but expected it to be Lucene file", e);
                return false;
            }
        }
        return false;
    }

    public boolean isSame(StoreFileMetadata other) {
        if (this.checksum == null || other.checksum == null) {
            return false;
        }
        return this.length == other.length && this.checksum.equals(other.checksum) && this.hash.equals((Object)other.hash);
    }

    public String toString() {
        return "name [" + this.name + "], length [" + this.length + "], checksum [" + this.checksum + "], writtenBy [" + this.writtenBy + "]";
    }

    public Version writtenBy() {
        return this.writtenBy;
    }

    public BytesRef hash() {
        return this.hash;
    }
}

