/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.breaker.CircuitBreaker;
import org.opensearch.common.breaker.CircuitBreakingException;
import org.opensearch.index.store.remote.filecache.CachedIndexInput;
import org.opensearch.index.store.remote.filecache.FileCacheStats;
import org.opensearch.index.store.remote.utils.cache.CacheUsage;
import org.opensearch.index.store.remote.utils.cache.RefCountedCache;
import org.opensearch.index.store.remote.utils.cache.SegmentedCache;
import org.opensearch.index.store.remote.utils.cache.stats.CacheStats;

public class FileCache
implements RefCountedCache<Path, CachedIndexInput> {
    private final SegmentedCache<Path, CachedIndexInput> theCache;
    private final CircuitBreaker circuitBreaker;

    public FileCache(SegmentedCache<Path, CachedIndexInput> cache, CircuitBreaker circuitBreaker) {
        this.theCache = cache;
        this.circuitBreaker = circuitBreaker;
    }

    public long capacity() {
        return this.theCache.capacity();
    }

    @Override
    public CachedIndexInput put(Path filePath, CachedIndexInput indexInput) {
        CachedIndexInput cachedIndexInput = this.theCache.put(filePath, indexInput);
        this.checkParentBreaker(filePath);
        return cachedIndexInput;
    }

    @Override
    public CachedIndexInput compute(Path key, BiFunction<? super Path, ? super CachedIndexInput, ? extends CachedIndexInput> remappingFunction) {
        CachedIndexInput cachedIndexInput = this.theCache.compute(key, remappingFunction);
        this.checkParentBreaker(key);
        return cachedIndexInput;
    }

    @Override
    public CachedIndexInput get(Path filePath) {
        return this.theCache.get(filePath);
    }

    @Override
    public void remove(Path filePath) {
        this.theCache.remove(filePath);
    }

    @Override
    public void clear() {
        this.theCache.clear();
    }

    @Override
    public long size() {
        return this.theCache.size();
    }

    @Override
    public void incRef(Path key) {
        this.theCache.incRef(key);
    }

    @Override
    public void decRef(Path key) {
        this.theCache.decRef(key);
    }

    @Override
    public long prune() {
        return this.theCache.prune();
    }

    @Override
    public long prune(Predicate<Path> keyPredicate) {
        return this.theCache.prune(keyPredicate);
    }

    @Override
    public CacheUsage usage() {
        return this.theCache.usage();
    }

    @Override
    public CacheStats stats() {
        return this.theCache.stats();
    }

    private void checkParentBreaker(Path filePath) {
        try {
            this.circuitBreaker.addEstimateBytesAndMaybeBreak(0L, "filecache_entry");
        }
        catch (CircuitBreakingException ex) {
            this.theCache.remove(filePath);
            throw new CircuitBreakingException("Unable to create file cache entries", ex.getBytesWanted(), ex.getByteLimit(), ex.getDurability());
        }
    }

    public void restoreFromDirectory(List<Path> fileCacheDataPaths) {
        fileCacheDataPaths.stream().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.resolve("RemoteLocalStore")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(dir -> {
            try {
                return Files.list(dir);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to process file cache directory. Please clear the file cache for node startup.", e);
            }
        }).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
            try {
                this.put(path.toAbsolutePath(), new RestoredCachedIndexInput(Files.size(path)));
                this.decRef(path.toAbsolutePath());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to retrieve cache file details. Please clear the file cache for node startup.", e);
            }
        });
    }

    public FileCacheStats fileCacheStats() {
        CacheStats stats = this.stats();
        CacheUsage usage = this.usage();
        return new FileCacheStats(System.currentTimeMillis(), usage.activeUsage(), this.capacity(), usage.usage(), stats.evictionWeight(), stats.hitCount(), stats.missCount());
    }

    private static class RestoredCachedIndexInput
    implements CachedIndexInput {
        private final long length;

        private RestoredCachedIndexInput(long length) {
            this.length = length;
        }

        @Override
        public IndexInput getIndexInput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public boolean isClosed() {
            return true;
        }

        @Override
        public void close() throws Exception {
        }
    }
}

