/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.replication.ReplicationMode;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.action.support.replication.ReplicationTask;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardClosedException;
import org.opensearch.index.shard.ShardNotInPrimaryModeException;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.replication.SegmentReplicationTargetService;
import org.opensearch.indices.replication.checkpoint.PublishCheckpointRequest;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.common.ReplicationTimer;
import org.opensearch.node.NodeClosedException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class PublishCheckpointAction
extends TransportReplicationAction<PublishCheckpointRequest, PublishCheckpointRequest, ReplicationResponse> {
    public static final String ACTION_NAME = "indices:admin/publishCheckpoint";
    protected static Logger logger = LogManager.getLogger(PublishCheckpointAction.class);
    private final SegmentReplicationTargetService replicationService;

    @Inject
    public PublishCheckpointAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, SegmentReplicationTargetService targetService) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, PublishCheckpointRequest::new, PublishCheckpointRequest::new, "refresh");
        this.replicationService = targetService;
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void doExecute(Task task, PublishCheckpointRequest request, ActionListener<ReplicationResponse> listener) {
        assert (false) : "use PublishCheckpointAction#publish";
    }

    @Override
    public ReplicationMode getReplicationMode(IndexShard indexShard) {
        if (indexShard.isRemoteTranslogEnabled()) {
            return ReplicationMode.FULL_REPLICATION;
        }
        return super.getReplicationMode(indexShard);
    }

    final void publish(final IndexShard indexShard, final ReplicationCheckpoint checkpoint) {
        String primaryAllocationId = indexShard.routingEntry().allocationId().getId();
        long primaryTerm = indexShard.getPendingPrimaryTerm();
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            PublishCheckpointRequest request = new PublishCheckpointRequest(checkpoint);
            final ReplicationTask task = (ReplicationTask)this.taskManager.register("transport", "segrep_publish_checkpoint", request);
            final ReplicationTimer timer = new ReplicationTimer();
            timer.start();
            this.transportService.sendChildRequest(indexShard.recoveryState().getTargetNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<PublishCheckpointRequest>(request, primaryAllocationId, primaryTerm), (Task)task, this.transportOptions, new TransportResponseHandler<ReplicationResponse>(){

                public ReplicationResponse read(StreamInput in) throws IOException {
                    return PublishCheckpointAction.this.newResponseInstance(in);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(ReplicationResponse response) {
                    timer.stop();
                    logger.trace(() -> new ParameterizedMessage("[shardId {}] Completed publishing checkpoint [{}], timing: {}", new Object[]{indexShard.shardId().getId(), checkpoint, timer.time()}));
                    task.setPhase("finished");
                    PublishCheckpointAction.this.taskManager.unregister(task);
                }

                @Override
                public void handleException(TransportException e) {
                    timer.stop();
                    logger.trace("[shardId {}] Failed to publish checkpoint, timing: {}", (Object)indexShard.shardId().getId(), (Object)timer.time());
                    task.setPhase("finished");
                    PublishCheckpointAction.this.taskManager.unregister(task);
                    if (ExceptionsHelper.unwrap((Throwable)((Object)e), (Class[])new Class[]{NodeClosedException.class, IndexNotFoundException.class, AlreadyClosedException.class, IndexShardClosedException.class, ShardNotInPrimaryModeException.class}) != null) {
                        return;
                    }
                    logger.warn((Message)new ParameterizedMessage("{} segment replication checkpoint publishing failed", (Object)indexShard.shardId()), (Throwable)((Object)e));
                }
            });
            logger.trace(() -> new ParameterizedMessage("[shardId {}] Publishing replication checkpoint [{}]", (Object)checkpoint.getShardId().getId(), (Object)checkpoint));
        }
    }

    @Override
    protected void shardOperationOnPrimary(PublishCheckpointRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<PublishCheckpointRequest, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> new TransportReplicationAction.PrimaryResult<PublishCheckpointRequest, ReplicationResponse>(request, new ReplicationResponse()));
    }

    @Override
    protected void shardOperationOnReplica(PublishCheckpointRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(replica);
        ActionListener.completeWith(listener, () -> {
            logger.trace(() -> new ParameterizedMessage("Checkpoint {} received on replica {}", (Object)request, (Object)replica.shardId()));
            if (request.getCheckpoint().getShardId().equals((Object)replica.shardId())) {
                this.replicationService.onNewCheckpoint(request.getCheckpoint(), replica);
            }
            return new TransportReplicationAction.ReplicaResult();
        });
    }
}

