/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ContextParser;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;

public final class PipelineConfiguration
extends AbstractDiffable<PipelineConfiguration>
implements ToXContentObject {
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("pipeline_config", true, () -> new Builder());
    private final String id;
    private final BytesReference config;
    private final XContentType xContentType;

    public static ContextParser<Void, PipelineConfiguration> getParser() {
        return (parser, context) -> ((Builder)PARSER.apply(parser, null)).build();
    }

    public PipelineConfiguration(String id, BytesReference config, XContentType xContentType) {
        this.id = Objects.requireNonNull(id);
        this.config = Objects.requireNonNull(config);
        this.xContentType = Objects.requireNonNull(xContentType);
    }

    public PipelineConfiguration(String id, BytesReference config, MediaType mediaType) {
        this(id, config, XContentType.fromMediaType((MediaType)mediaType));
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getConfigAsMap() {
        return (Map)XContentHelper.convertToMap(this.config, true, this.xContentType).v2();
    }

    XContentType getXContentType() {
        return this.xContentType;
    }

    BytesReference getConfig() {
        return this.config;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("config", this.getConfigAsMap());
        builder.endObject();
        return builder;
    }

    public static PipelineConfiguration readFrom(StreamInput in) throws IOException {
        return new PipelineConfiguration(in.readString(), in.readBytesReference(), (XContentType)in.readEnum(XContentType.class));
    }

    public static Diff<PipelineConfiguration> readDiffFrom(StreamInput in) throws IOException {
        return PipelineConfiguration.readDiffFrom(PipelineConfiguration::readFrom, in);
    }

    public String toString() {
        return Strings.toString((MediaType)XContentType.JSON, (ToXContent)this);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBytesReference(this.config);
        out.writeEnum((Enum)this.xContentType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineConfiguration that = (PipelineConfiguration)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.getConfigAsMap().equals(that.getConfigAsMap());
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.getConfigAsMap().hashCode();
        return result;
    }

    static {
        PARSER.declareString(Builder::setId, new ParseField("id", new String[0]));
        PARSER.declareField((parser, builder, aVoid) -> {
            XContentBuilder contentBuilder = XContentBuilder.builder((XContent)parser.contentType().xContent());
            contentBuilder.generator().copyCurrentStructure(parser);
            builder.setConfig(BytesReference.bytes((XContentBuilder)contentBuilder), contentBuilder.contentType());
        }, new ParseField("config", new String[0]), ObjectParser.ValueType.OBJECT);
    }

    private static class Builder {
        private String id;
        private BytesReference config;
        private XContentType xContentType;

        private Builder() {
        }

        void setId(String id) {
            this.id = id;
        }

        void setConfig(BytesReference config, MediaType mediaType) {
            if (!(mediaType instanceof XContentType)) {
                throw new IllegalArgumentException("PipelineConfiguration does not support media type [" + mediaType.getClass() + "]");
            }
            this.config = config;
            this.xContentType = XContentType.fromMediaType((MediaType)mediaType);
        }

        PipelineConfiguration build() {
            return new PipelineConfiguration(this.id, this.config, this.xContentType);
        }
    }
}

