/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.opensearch.common.CheckedFunction;
import org.opensearch.search.aggregations.AggregationExecutionException;
import org.opensearch.search.aggregations.AggregationReduceableSearchResult;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.BucketCollector;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.MultiBucketCollector;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.profile.query.InternalProfileCollector;
import org.opensearch.search.query.ReduceableSearchResult;

class AggregationCollectorManager
implements CollectorManager<Collector, ReduceableSearchResult> {
    private final SearchContext context;
    private final CheckedFunction<SearchContext, List<Aggregator>, IOException> aggProvider;
    private final String collectorReason;

    AggregationCollectorManager(SearchContext context, CheckedFunction<SearchContext, List<Aggregator>, IOException> aggProvider, String collectorReason) {
        this.context = context;
        this.aggProvider = aggProvider;
        this.collectorReason = collectorReason;
    }

    public Collector newCollector() throws IOException {
        Collector collector = AggregationCollectorManager.createCollector(this.context, (List)this.aggProvider.apply((Object)this.context), this.collectorReason);
        assert (collector != BucketCollector.NO_OP_COLLECTOR);
        return collector;
    }

    public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        LinkedList<Collector> allCollectors = new LinkedList<Collector>(collectors);
        while (!allCollectors.isEmpty()) {
            Collector currentCollector = (Collector)allCollectors.pop();
            if (currentCollector instanceof Aggregator) {
                aggregators.add((Aggregator)currentCollector);
                continue;
            }
            if (currentCollector instanceof InternalProfileCollector) {
                if (((InternalProfileCollector)currentCollector).getCollector() instanceof Aggregator) {
                    aggregators.add((Aggregator)((InternalProfileCollector)currentCollector).getCollector());
                    continue;
                }
                if (!(((InternalProfileCollector)currentCollector).getCollector() instanceof MultiBucketCollector)) continue;
                allCollectors.addAll(Arrays.asList(((MultiBucketCollector)((InternalProfileCollector)currentCollector).getCollector()).getCollectors()));
                continue;
            }
            if (!(currentCollector instanceof MultiBucketCollector)) continue;
            allCollectors.addAll(Arrays.asList(((MultiBucketCollector)currentCollector).getCollectors()));
        }
        ArrayList<InternalAggregation> internals = new ArrayList<InternalAggregation>(aggregators.size());
        this.context.aggregations().resetBucketMultiConsumer();
        for (Aggregator aggregator : aggregators) {
            try {
                aggregator.postCollection();
                internals.add(aggregator.buildTopLevel());
            }
            catch (IOException e) {
                throw new AggregationExecutionException("Failed to build aggregation [" + aggregator.name() + "]", e);
            }
        }
        InternalAggregations internalAggregations = new InternalAggregations(internals, this.context.request().source().aggregations()::buildPipelineTree);
        if (collectors.size() > 1) {
            return new AggregationReduceableSearchResult(InternalAggregations.topLevelReduce(Collections.singletonList(internalAggregations), this.context.partial()));
        }
        return new AggregationReduceableSearchResult(internalAggregations);
    }

    static Collector createCollector(SearchContext context, List<Aggregator> collectors, String reason) throws IOException {
        Object collector = MultiBucketCollector.wrap(collectors);
        collector.preCollection();
        if (context.getProfilers() != null) {
            collector = new InternalProfileCollector((Collector)collector, reason, Collections.emptyList());
        }
        return collector;
    }
}

