/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.bucket.sampler.DiversifiedAggregatorFactory;
import org.opensearch.search.aggregations.bucket.sampler.DiversifiedAggregatorSupplier;
import org.opensearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.aggregations.support.ValuesSourceType;

public class DiversifiedAggregationBuilder
extends ValuesSourceAggregationBuilder<DiversifiedAggregationBuilder> {
    public static final String NAME = "diversified_sampler";
    public static final ValuesSourceRegistry.RegistryKey<DiversifiedAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<DiversifiedAggregatorSupplier>("diversified_sampler", DiversifiedAggregatorSupplier.class);
    public static final int MAX_DOCS_PER_VALUE_DEFAULT = 1;
    public static final ObjectParser<DiversifiedAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"diversified_sampler", DiversifiedAggregationBuilder::new);
    private int shardSize = 100;
    private int maxDocsPerValue = 1;
    private String executionHint = null;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        DiversifiedAggregatorFactory.registerAggregators(builder);
    }

    public DiversifiedAggregationBuilder(String name) {
        super(name);
    }

    protected DiversifiedAggregationBuilder(DiversifiedAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.shardSize = clone.shardSize;
        this.maxDocsPerValue = clone.maxDocsPerValue;
        this.executionHint = clone.executionHint;
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.BYTES;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new DiversifiedAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public DiversifiedAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.shardSize = in.readVInt();
        this.maxDocsPerValue = in.readVInt();
        this.executionHint = in.readOptionalString();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shardSize);
        out.writeVInt(this.maxDocsPerValue);
        out.writeOptionalString(this.executionHint);
    }

    public DiversifiedAggregationBuilder shardSize(int shardSize) {
        if (shardSize < 0) {
            throw new IllegalArgumentException("[shardSize] must be greater than or equal to 0. Found [" + shardSize + "] in [" + this.name + "]");
        }
        this.shardSize = shardSize;
        return this;
    }

    public int shardSize() {
        return this.shardSize;
    }

    public DiversifiedAggregationBuilder maxDocsPerValue(int maxDocsPerValue) {
        if (maxDocsPerValue < 0) {
            throw new IllegalArgumentException("[maxDocsPerValue] must be greater than or equal to 0. Found [" + maxDocsPerValue + "] in [" + this.name + "]");
        }
        this.maxDocsPerValue = maxDocsPerValue;
        return this;
    }

    public int maxDocsPerValue() {
        return this.maxDocsPerValue;
    }

    public DiversifiedAggregationBuilder executionHint(String executionHint) {
        this.executionHint = executionHint;
        return this;
    }

    public String executionHint() {
        return this.executionHint;
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    @Override
    protected ValuesSourceAggregatorFactory innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new DiversifiedAggregatorFactory(this.name, config, this.shardSize, this.maxDocsPerValue, this.executionHint, queryShardContext, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SamplerAggregator.SHARD_SIZE_FIELD.getPreferredName(), this.shardSize);
        builder.field(SamplerAggregator.MAX_DOCS_PER_VALUE_FIELD.getPreferredName(), this.maxDocsPerValue);
        if (this.executionHint != null) {
            builder.field(SamplerAggregator.EXECUTION_HINT_FIELD.getPreferredName(), this.executionHint);
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.shardSize, this.maxDocsPerValue, this.executionHint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DiversifiedAggregationBuilder other = (DiversifiedAggregationBuilder)obj;
        return Objects.equals(this.shardSize, other.shardSize) && Objects.equals(this.maxDocsPerValue, other.maxDocsPerValue) && Objects.equals(this.executionHint, other.executionHint);
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, false, false);
        PARSER.declareInt(DiversifiedAggregationBuilder::shardSize, SamplerAggregator.SHARD_SIZE_FIELD);
        PARSER.declareInt(DiversifiedAggregationBuilder::maxDocsPerValue, SamplerAggregator.MAX_DOCS_PER_VALUE_FIELD);
        PARSER.declareString(DiversifiedAggregationBuilder::executionHint, SamplerAggregator.EXECUTION_HINT_FIELD);
    }
}

