/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.util.SetBackedScalingCuckooFilter;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.bucket.terms.InternalMappedRareTerms;
import org.opensearch.search.aggregations.bucket.terms.InternalRareTerms;

public class StringRareTerms
extends InternalMappedRareTerms<StringRareTerms, Bucket> {
    public static final String NAME = "srareterms";

    StringRareTerms(String name, BucketOrder order, Map<String, Object> metadata, DocValueFormat format, List<Bucket> buckets, long maxDocCount, SetBackedScalingCuckooFilter filter) {
        super(name, order, metadata, format, buckets, maxDocCount, filter);
    }

    public StringRareTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public StringRareTerms create(List<Bucket> buckets) {
        return new StringRareTerms(this.name, this.order, (Map<String, Object>)this.metadata, this.format, buckets, this.maxDocCount, this.filter);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.termBytes, prototype.getDocCount(), aggregations, prototype.format);
    }

    @Override
    protected StringRareTerms createWithFilter(String name, List<Bucket> buckets, SetBackedScalingCuckooFilter filterFilter) {
        return new StringRareTerms(name, this.order, (Map<String, Object>)this.metadata, this.format, buckets, this.maxDocCount, filterFilter);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    @Override
    public boolean containsTerm(SetBackedScalingCuckooFilter filter, Bucket bucket) {
        return filter.mightContain(bucket.termBytes);
    }

    @Override
    public void addToFilter(SetBackedScalingCuckooFilter filter, Bucket bucket) {
        filter.add(bucket.termBytes);
    }

    @Override
    Bucket createBucket(long docCount, InternalAggregations aggs, Bucket prototype) {
        return new Bucket(prototype.termBytes, docCount, aggs, this.format);
    }

    public static class Bucket
    extends InternalRareTerms.Bucket<Bucket> {
        BytesRef termBytes;

        public Bucket(BytesRef term, long docCount, InternalAggregations aggregations, DocValueFormat format) {
            super(docCount, aggregations, format);
            this.termBytes = term;
        }

        public Bucket(StreamInput in, DocValueFormat format) throws IOException {
            super(in, format);
            this.termBytes = in.readBytesRef();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeBytesRef(this.termBytes);
        }

        @Override
        public Object getKey() {
            return this.getKeyAsString();
        }

        @Override
        public Number getKeyAsNumber() {
            try {
                return Long.parseLong(this.termBytes.utf8ToString());
            }
            catch (NumberFormatException ignored) {
                return Double.parseDouble(this.termBytes.utf8ToString());
            }
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.termBytes).toString();
        }

        @Override
        public int compareKey(Bucket other) {
            return this.termBytes.compareTo(other.termBytes);
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKeyAsString());
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.termBytes, ((Bucket)obj).termBytes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.termBytes);
        }
    }
}

