/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import com.carrotsearch.hppc.DoubleArrayList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.pipeline.BucketMetricsParser;
import org.opensearch.search.aggregations.pipeline.BucketMetricsPipelineAggregationBuilder;
import org.opensearch.search.aggregations.pipeline.PercentilesBucketPipelineAggregator;
import org.opensearch.search.aggregations.pipeline.PipelineAggregator;

public class PercentilesBucketPipelineAggregationBuilder
extends BucketMetricsPipelineAggregationBuilder<PercentilesBucketPipelineAggregationBuilder> {
    public static final String NAME = "percentiles_bucket";
    static final ParseField PERCENTS_FIELD = new ParseField("percents", new String[0]);
    static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    private double[] percents = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};
    private boolean keyed = true;
    public static final PipelineAggregator.Parser PARSER = new BucketMetricsParser(){

        protected PercentilesBucketPipelineAggregationBuilder buildFactory(String pipelineAggregatorName, String bucketsPath, Map<String, Object> params) {
            Boolean keyed;
            PercentilesBucketPipelineAggregationBuilder factory = new PercentilesBucketPipelineAggregationBuilder(pipelineAggregatorName, bucketsPath);
            double[] percents = (double[])params.get(PERCENTS_FIELD.getPreferredName());
            if (percents != null) {
                factory.setPercents(percents);
            }
            if ((keyed = (Boolean)params.get(KEYED_FIELD.getPreferredName())) != null) {
                factory.setKeyed(keyed);
            }
            return factory;
        }

        @Override
        protected boolean token(XContentParser parser, String field, XContentParser.Token token, Map<String, Object> params) throws IOException {
            if (PERCENTS_FIELD.match(field, parser.getDeprecationHandler()) && token == XContentParser.Token.START_ARRAY) {
                DoubleArrayList percents = new DoubleArrayList(10);
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    percents.add(parser.doubleValue());
                }
                params.put(PERCENTS_FIELD.getPreferredName(), percents.toArray());
                return true;
            }
            if (KEYED_FIELD.match(field, parser.getDeprecationHandler()) && token == XContentParser.Token.VALUE_BOOLEAN) {
                params.put(KEYED_FIELD.getPreferredName(), parser.booleanValue());
                return true;
            }
            return false;
        }
    };

    public PercentilesBucketPipelineAggregationBuilder(String name, String bucketsPath) {
        super(name, NAME, new String[]{bucketsPath});
    }

    public PercentilesBucketPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.percents = in.readDoubleArray();
        if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            this.keyed = in.readBoolean();
        }
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.percents);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            out.writeBoolean(this.keyed);
        }
    }

    public double[] getPercents() {
        return this.percents;
    }

    public PercentilesBucketPipelineAggregationBuilder setPercents(double[] percents) {
        if (percents == null) {
            throw new IllegalArgumentException("[percents] must not be null: [" + this.name + "]");
        }
        double[] dArray = percents;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double p = dArray[i];
            if (p != null && !(p < 0.0) && !(p > 100.0)) continue;
            throw new IllegalArgumentException(PERCENTS_FIELD.getPreferredName() + " must only contain non-null doubles from 0.0-100.0 inclusive");
        }
        this.percents = percents;
        return this;
    }

    public PercentilesBucketPipelineAggregationBuilder setKeyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public boolean getKeyed() {
        return this.keyed;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metadata) {
        return new PercentilesBucketPipelineAggregator(this.name, this.percents, this.keyed, this.bucketsPaths, this.gapPolicy(), this.formatter(), metadata);
    }

    @Override
    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        super.validate(context);
        double[] dArray = this.percents;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double p = dArray[i];
            if (p != null && !(p < 0.0) && !(p > 100.0)) continue;
            context.addValidationError(PERCENTS_FIELD.getPreferredName() + " must only contain non-null doubles from 0.0-100.0 inclusive");
            return;
        }
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.percents != null) {
            builder.array(PERCENTS_FIELD.getPreferredName(), this.percents);
        }
        builder.field(KEYED_FIELD.getPreferredName(), this.keyed);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.percents), this.keyed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PercentilesBucketPipelineAggregationBuilder other = (PercentilesBucketPipelineAggregationBuilder)obj;
        return Objects.deepEquals(this.percents, other.percents) && Objects.equals(this.keyed, other.keyed);
    }

    public String getWriteableName() {
        return NAME;
    }
}

