/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.painless.action.PainlessContextClassBindingInfo;
import org.opensearch.painless.action.PainlessContextClassInfo;
import org.opensearch.painless.action.PainlessContextInstanceBindingInfo;
import org.opensearch.painless.action.PainlessContextMethodInfo;
import org.opensearch.painless.lookup.PainlessClassBinding;
import org.opensearch.painless.lookup.PainlessInstanceBinding;
import org.opensearch.painless.lookup.PainlessLookup;
import org.opensearch.painless.lookup.PainlessMethod;
import org.opensearch.script.ScriptContext;

public class PainlessContextInfo
implements Writeable,
ToXContentObject {
    public static final ParseField NAME = new ParseField("name", new String[0]);
    public static final ParseField CLASSES = new ParseField("classes", new String[0]);
    public static final ParseField IMPORTED_METHODS = new ParseField("imported_methods", new String[0]);
    public static final ParseField CLASS_BINDINGS = new ParseField("class_bindings", new String[0]);
    public static final ParseField INSTANCE_BINDINGS = new ParseField("instance_bindings", new String[0]);
    private static final ConstructingObjectParser<PainlessContextInfo, Void> PARSER = new ConstructingObjectParser(PainlessContextInfo.class.getCanonicalName(), v -> new PainlessContextInfo((String)v[0], (List)v[1], (List)v[2], (List)v[3], (List)v[4]));
    private final String name;
    private final List<PainlessContextClassInfo> classes;
    private final List<PainlessContextMethodInfo> importedMethods;
    private final List<PainlessContextClassBindingInfo> classBindings;
    private final List<PainlessContextInstanceBindingInfo> instanceBindings;

    public PainlessContextInfo(ScriptContext<?> scriptContext, PainlessLookup painlessLookup) {
        this(scriptContext.name, painlessLookup.getClasses().stream().map(javaClass -> new PainlessContextClassInfo((Class<?>)javaClass, javaClass == painlessLookup.canonicalTypeNameToType(javaClass.getName().substring(javaClass.getName().lastIndexOf(46) + 1).replace('$', '.')), painlessLookup.lookupPainlessClass((Class<?>)javaClass))).collect(Collectors.toList()), painlessLookup.getImportedPainlessMethodsKeys().stream().map(importedPainlessMethodKey -> {
            String[] split = importedPainlessMethodKey.split("/");
            String importedPainlessMethodName = split[0];
            int importedPainlessMethodArity = Integer.parseInt(split[1]);
            PainlessMethod importedPainlessMethod = painlessLookup.lookupImportedPainlessMethod(importedPainlessMethodName, importedPainlessMethodArity);
            return new PainlessContextMethodInfo(importedPainlessMethod);
        }).collect(Collectors.toList()), painlessLookup.getPainlessClassBindingsKeys().stream().map(painlessClassBindingKey -> {
            String[] split = painlessClassBindingKey.split("/");
            String painlessClassBindingName = split[0];
            int painlessClassBindingArity = Integer.parseInt(split[1]);
            PainlessClassBinding painlessClassBinding = painlessLookup.lookupPainlessClassBinding(painlessClassBindingName, painlessClassBindingArity);
            return new PainlessContextClassBindingInfo(painlessClassBinding);
        }).collect(Collectors.toList()), painlessLookup.getPainlessInstanceBindingsKeys().stream().map(painlessInstanceBindingKey -> {
            String[] split = painlessInstanceBindingKey.split("/");
            String painlessInstanceBindingName = split[0];
            int painlessInstanceBindingArity = Integer.parseInt(split[1]);
            PainlessInstanceBinding painlessInstanceBinding = painlessLookup.lookupPainlessInstanceBinding(painlessInstanceBindingName, painlessInstanceBindingArity);
            return new PainlessContextInstanceBindingInfo(painlessInstanceBinding);
        }).collect(Collectors.toList()));
    }

    public PainlessContextInfo(String name, List<PainlessContextClassInfo> classes, List<PainlessContextMethodInfo> importedMethods, List<PainlessContextClassBindingInfo> classBindings, List<PainlessContextInstanceBindingInfo> instanceBindings) {
        this.name = Objects.requireNonNull(name);
        classes = new ArrayList<PainlessContextClassInfo>((Collection)Objects.requireNonNull(classes));
        classes.sort(Comparator.comparing(PainlessContextClassInfo::getSortValue));
        this.classes = Collections.unmodifiableList(classes);
        importedMethods = new ArrayList<PainlessContextMethodInfo>((Collection)Objects.requireNonNull(importedMethods));
        importedMethods.sort(Comparator.comparing(PainlessContextMethodInfo::getSortValue));
        this.importedMethods = Collections.unmodifiableList(importedMethods);
        classBindings = new ArrayList<PainlessContextClassBindingInfo>((Collection)Objects.requireNonNull(classBindings));
        classBindings.sort(Comparator.comparing(PainlessContextClassBindingInfo::getSortValue));
        this.classBindings = Collections.unmodifiableList(classBindings);
        instanceBindings = new ArrayList<PainlessContextInstanceBindingInfo>((Collection)Objects.requireNonNull(instanceBindings));
        instanceBindings.sort(Comparator.comparing(PainlessContextInstanceBindingInfo::getSortValue));
        this.instanceBindings = Collections.unmodifiableList(instanceBindings);
    }

    public PainlessContextInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.classes = Collections.unmodifiableList(in.readList(PainlessContextClassInfo::new));
        this.importedMethods = Collections.unmodifiableList(in.readList(PainlessContextMethodInfo::new));
        this.classBindings = Collections.unmodifiableList(in.readList(PainlessContextClassBindingInfo::new));
        this.instanceBindings = Collections.unmodifiableList(in.readList(PainlessContextInstanceBindingInfo::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeList(this.classes);
        out.writeList(this.importedMethods);
        out.writeList(this.classBindings);
        out.writeList(this.instanceBindings);
    }

    public static PainlessContextInfo fromXContent(XContentParser parser) {
        return (PainlessContextInfo)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(CLASSES.getPreferredName(), this.classes);
        builder.field(IMPORTED_METHODS.getPreferredName(), this.importedMethods);
        builder.field(CLASS_BINDINGS.getPreferredName(), this.classBindings);
        builder.field(INSTANCE_BINDINGS.getPreferredName(), this.instanceBindings);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PainlessContextInfo that = (PainlessContextInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.classes, that.classes) && Objects.equals(this.importedMethods, that.importedMethods) && Objects.equals(this.classBindings, that.classBindings) && Objects.equals(this.instanceBindings, that.instanceBindings);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.classes, this.importedMethods, this.classBindings, this.instanceBindings);
    }

    public String toString() {
        return "PainlessContextInfo{name='" + this.name + "', classes=" + this.classes + ", importedMethods=" + this.importedMethods + ", classBindings=" + this.classBindings + ", instanceBindings=" + this.instanceBindings + "}";
    }

    public String getName() {
        return this.name;
    }

    public List<PainlessContextClassInfo> getClasses() {
        return this.classes;
    }

    public List<PainlessContextMethodInfo> getImportedMethods() {
        return this.importedMethods;
    }

    public List<PainlessContextClassBindingInfo> getClassBindings() {
        return this.classBindings;
    }

    public List<PainlessContextInstanceBindingInfo> getInstanceBindings() {
        return this.instanceBindings;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> PainlessContextClassInfo.fromXContent(p), CLASSES);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> PainlessContextMethodInfo.fromXContent(p), IMPORTED_METHODS);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> PainlessContextClassBindingInfo.fromXContent(p), CLASS_BINDINGS);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> PainlessContextInstanceBindingInfo.fromXContent(p), INSTANCE_BINDINGS);
    }
}

