/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper.murmur3;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.search.lookup.SearchLookup;

public class Murmur3FieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "murmur3";
    public static ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));

    private static Murmur3FieldMapper toType(FieldMapper in) {
        return (Murmur3FieldMapper)in;
    }

    protected Murmur3FieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init((FieldMapper)this);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        Object value = context.externalValueSet() ? context.externalValue() : context.parser().textOrNull();
        if (value != null) {
            BytesRef bytes = new BytesRef((CharSequence)value.toString());
            long hash = MurmurHash3.hash128((byte[])bytes.bytes, (int)bytes.offset, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128()).h1;
            context.doc().add((IndexableField)new SortedNumericDocValuesField(this.fieldType().name(), hash));
            if (this.fieldType().isStored()) {
                context.doc().add((IndexableField)new StoredField(this.name(), hash));
            }
        }
    }

    public static class Murmur3FieldType
    extends MappedFieldType {
        private Murmur3FieldType(String name, boolean isStored, Map<String, String> meta) {
            super(name, false, isStored, true, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
        }

        public String typeName() {
            return Murmur3FieldMapper.CONTENT_TYPE;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.LONG);
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.toString((String)this.name(), (QueryShardContext)context, (String)format);
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Murmur3 fields are not searchable: [" + this.name() + "]", new Object[0]);
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> Murmur3FieldMapper.toType(m).fieldType().isStored(), (boolean)false);
        final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.stored, this.meta);
        }

        public Murmur3FieldMapper build(Mapper.BuilderContext context) {
            return new Murmur3FieldMapper(this.name, new Murmur3FieldType(this.buildFullName(context), (Boolean)this.stored.getValue(), (Map)this.meta.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build());
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.freeze();
        }
    }
}

