set(PACKAGE_VERSION 4.9.2)

# Match the version just as precisely as it was specified

if(PACKAGE_FIND_VERSION_MAJOR STREQUAL "4")
  set(_MAJOR_MATCHES TRUE)
else()
  set(_MAJOR_MATCHES FALSE)
endif()
if(PACKAGE_FIND_VERSION_MINOR STREQUAL "9")
  set(_MINOR_MATCHES TRUE)
else()
  set(_MINOR_MATCHES FALSE)
endif()
if(PACKAGE_FIND_VERSION_PATCH STREQUAL "2")
  set(_PATCH_MATCHES TRUE)
else()
  set(_PATCH_MATCHES FALSE)
endif()

if(PACKAGE_FIND_VERSION_COUNT EQUAL 0)
  set(PACKAGE_VERSION_COMPATIBLE TRUE)
elseif(PACKAGE_FIND_VERSION_COUNT EQUAL 1 AND _MAJOR_MATCHES)
  set(PACKAGE_VERSION_COMPATIBLE TRUE)
elseif(PACKAGE_FIND_VERSION_COUNT EQUAL 2 AND
       _MAJOR_MATCHES AND _MINOR_MATCHES)
  set(PACKAGE_VERSION_COMPATIBLE TRUE)
elseif(PACKAGE_FIND_VERSION_COUNT GREATER 2 AND
       _MAJOR_MATCHES AND _MINOR_MATCHES AND _PATCH_MATCHES)
  set(PACKAGE_VERSION_COMPATIBLE TRUE)
else()
  set(PACKAGE_VERSION_COMPATIBLE FALSE)
endif()

if(PACKAGE_FIND_VERSION STREQUAL PACKAGE_VERSION)
  set(PACKAGE_VERSION_EXACT TRUE)
endif()

# bitness checks copied from autogenerated CMakePackageConfigHelpers version file

# if the installed or the using project don't have CMAKE_SIZEOF_VOID_P set, ignore it:
if("${CMAKE_SIZEOF_VOID_P}" STREQUAL "" OR "8" STREQUAL "")
  return()
endif()

# check that the installed version has the same 32/64bit-ness as the one which is currently searching:
if(NOT CMAKE_SIZEOF_VOID_P STREQUAL "8")
  math(EXPR installedBits "8 * 8")
  set(PACKAGE_VERSION "${PACKAGE_VERSION} (${installedBits}bit)")
  set(PACKAGE_VERSION_UNSUITABLE TRUE)
endif()
